<?php
    
    //para servidor:

    require_once "../sunat/librerias/robrichards/src/xmlseclibs.php";
    require_once "../sunat/librerias/pclzip/pclzip.lib.php";
    require_once "../sunat/librerias/feedsoap/feedSoap.php";
    include_once "../pdf/letras/NumeroALetras.php";

    use RobRichards\XMLSecLibs\XMLSecurityDSig;
    use RobRichards\XMLSecLibs\XMLSecurityKey;

    function wsdlURL() 
    {
        //URL BETA para enviar las solicitudes a SUNAT
        $beta = 'https://e-beta.sunat.gob.pe/ol-ti-itcpfegem-beta/billService?wsdl';
        
        //URL PRODUCCION para enviar las solicitudes a SUNAT
        $prod = realpath(base_path().'/sunat/webservice/production.xml');

        if (env('URL_SUNAT') == "BETA") {
            return $beta;
        } else {
            return $prod;
        }
    }

    function wsdlURL_Cdr() 
    {
        //$cdr = 'https://www.sunat.gob.pe/ol-it-wsconscpegem/billConsultService?wsdl';

        $cdr = 'https://e-factura.sunat.gob.pe/ol-it-wsconscpegem/billConsultService?wsdl';

        return $cdr;
    }

    function soapCall($wsdlURL, $callFunction = "", $XMLString) 
    {
        $client = new feedSoap($wsdlURL, array('trace' => true));
        $reply  = $client->SoapClientCall($XMLString);
        $client->__call("$callFunction", array(), array());
        return $client->__getLastResponse();
    }

    function obtenerArchivosPEM()
    {     
        //Contraseña del certificado
        $contraseña = env('CERTIFICADO_PASSWORD');
        //Nombre del certificado con el formato .pfx
        $nombreArchivo = base_path()."/sunat/credenciales/certificado/certificado.pfx";
        //Devolvemos el el certificado como un string (cadena)
        $pkcs12 = file_get_contents($nombreArchivo);
        //Declaramos un arreglo para recuperar los certificados
        $certificados = array();
        //Pasamos los parámetros
        $respuesta = openssl_pkcs12_read($pkcs12, $certificados, $contraseña);
        //Si la respuesta es TRUE es porque se ha recuperado correctamente los certificados
        if ($respuesta) {
            $publicKeyPem  = $certificados['cert']; //Archivo público
            $privateKeyPem = $certificados['pkey']; //Archivo privado
            //guardo la clave publica y privada en mi directorio en formato .pem
            file_put_contents(base_path()."/sunat/credenciales/llaves/private_key.pem", $privateKeyPem);
            file_put_contents(base_path()."/sunat/credenciales/llaves/public_key.pem", $publicKeyPem);
            chmod(base_path()."/sunat/credenciales/llaves/private_key.pem", 0777);
            chmod(base_path()."/sunat/credenciales/llaves/public_key.pem", 0777);

            echo "- Llaves digitales creadas";
        } 
        else {
          echo "- Error al crear llaves digitales";
        }
    }

    /*****************************************************************************************************************/
    /* CREAR FACTURA BOLETA  XML
    /*****************************************************************************************************************/
    function crearComprobanteXML(array $data) 
    {
        $invoice='<?xml version="1.0" encoding="UTF-8"?>'
            .'<Invoice xmlns="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"
                    xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
                    xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
                    xmlns:ccts="urn:un:unece:uncefact:documentation:2"
                    xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
                    xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
                    xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
                    xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
                    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">'

                .'<ext:UBLExtensions>'
                    .'<ext:UBLExtension>'
                      .'<ext:ExtensionContent>'
                      .'</ext:ExtensionContent>'
                    .'</ext:UBLExtension>'
                .'</ext:UBLExtensions>'

                .'<cbc:UBLVersionID>2.1</cbc:UBLVersionID>'
                .'<cbc:CustomizationID>2.0</cbc:CustomizationID>'
                .'<cbc:ID>'.$data['comprobante']['nombre'].'</cbc:ID>'
                .'<cbc:IssueDate>'.$data['comprobante']['fecha'].'</cbc:IssueDate>'
                .'<cbc:IssueTime>'.$data['comprobante']['hora'].'</cbc:IssueTime>'

                .'<cbc:InvoiceTypeCode listID="0101"
                       listAgencyName="PE:SUNAT"
                       listName="SUNAT:Identificador de Tipo de Documento"
                       listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo01">'.$data['comprobante']['tipo_comprobante'].'</cbc:InvoiceTypeCode>'
                .'<cbc:Note languageLocaleID="1000">'.NumeroALetras::convertir($data['comprobante']['total'], 'soles', 'centimos').'</cbc:Note>'
                .'<cbc:DocumentCurrencyCode listID="ISO 4217 Alpha" listName="Currency" listAgencyName="United Nations Economic Commission for Europe">PEN</cbc:DocumentCurrencyCode>'
                .'<cbc:LineCountNumeric>'.sizeof($data['detalle']).'</cbc:LineCountNumeric>'

                .'<cac:Signature>'
                    .'<cbc:ID>IDSignKG</cbc:ID>'
                    .'<cac:SignatoryParty>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID>'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                      .'</cac:PartyName>'
                    .'</cac:SignatoryParty>'
                    .'<cac:DigitalSignatureAttachment>'
                      .'<cac:ExternalReference>'
                        .'<cbc:URI>#SignatureKG</cbc:URI>'
                      .'</cac:ExternalReference>'
                    .'</cac:DigitalSignatureAttachment>'
                .'</cac:Signature>'

                .'<cac:AccountingSupplierParty>'
                    .'<cac:Party>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID schemeID="6" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                     .'</cac:PartyName>'
                      .'<cac:PartyLegalEntity>'
                        .'<cbc:RegistrationName><![CDATA['.$data['empresa']['razon_social'].']]></cbc:RegistrationName>'
                        .'<cac:RegistrationAddress>'
                          .'<cbc:AddressTypeCode>0000</cbc:AddressTypeCode>'
                        .'</cac:RegistrationAddress>'
                      .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingSupplierParty>'

                .'<cac:AccountingCustomerParty>'
                    .'<cac:Party>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID schemeID="'.$data['comprobante']['tipo_doc_cliente'].'" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$data['comprobante']['num_doc_cliente'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyLegalEntity>'
                        .'<cbc:RegistrationName><![CDATA['.$data['comprobante']['nombre_cliente'].']]></cbc:RegistrationName>'
                      .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingCustomerParty>'


                //Inicio Tipo de Pago
                .'<cac:PaymentTerms>'
                    .'<cbc:ID>FormaPago</cbc:ID>'
                    .'<cbc:PaymentMeansID>'.$data['comprobante']['tipo_pago'].'</cbc:PaymentMeansID>';
                    if ($data['comprobante']['tipo_pago'] == 'Credito') {
                        $invoice.= '<cbc:Amount currencyID="PEN">'.$data['comprobante']['total'].'</cbc:Amount>';
                    }
                $invoice.= '</cac:PaymentTerms>';
                //Fin Tipo de Pago
                //Inicio CUOTAS
                if ($data['comprobante']['tipo_pago'] == 'Credito') {
                    
                        $invoice.= '<cac:PaymentTerms>'
                            .'<cbc:ID>FormaPago</cbc:ID>'
                            .'<cbc:PaymentMeansID>Cuota001</cbc:PaymentMeansID>'
                            .'<cbc:Amount currencyID="PEN">'.$data['comprobante']['total'].'</cbc:Amount>'
                            .'<cbc:PaymentDueDate>'.$data['comprobante']['fecha_pago'].'</cbc:PaymentDueDate>'
                        .'</cac:PaymentTerms>';                    
                }
                //Fin CUOTAS
                $invoice.= '<cac:TaxTotal>'

                    .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxSubtotal>'
                      .'<cbc:TaxableAmount currencyID="PEN">'.$data['comprobante']['subtotal'].'</cbc:TaxableAmount>'
                      .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                      .'<cac:TaxCategory>'
                        .'<cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">S</cbc:ID>'
                        .'<cac:TaxScheme>'
                          .'<cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">1000</cbc:ID>'
                          .'<cbc:Name>IGV</cbc:Name>'
                          .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                        .'</cac:TaxScheme>'
                      .'</cac:TaxCategory>'
                    .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'

                .'<cac:LegalMonetaryTotal>'
                     // Subtotal
                    .'<cbc:LineExtensionAmount currencyID="PEN">'.$data['comprobante']['subtotal'].'</cbc:LineExtensionAmount>'
                    //Total incluye IGV
                    .'<cbc:TaxInclusiveAmount currencyID="PEN">'.$data['comprobante']['total'].'</cbc:TaxInclusiveAmount>'
                    // Total de descuentos 
                    .'<cbc:AllowanceTotalAmount currencyID="PEN">0.00</cbc:AllowanceTotalAmount>'
                    //Total de otros cargos 
                    .'<cbc:ChargeTotalAmount currencyID="PEN">0</cbc:ChargeTotalAmount>'
                    //Monto a pagar, PayableAmount = TaxInclusiveAmount(allowance Applied)  + ChargeTotalAmount - PrepaidAmount 
                    .'<cbc:PayableAmount currencyID="PEN">'.$data['comprobante']['total'].'</cbc:PayableAmount>'
                .'</cac:LegalMonetaryTotal>';


        for ($i=0; $i < sizeof($data['detalle']) ; $i++) {     
            $invoice.= '<cac:InvoiceLine>'
                .'<cbc:ID>'.($i+1).'</cbc:ID>'
                .'<cbc:InvoicedQuantity unitCode="BX" unitCodeListID="UN/ECE rec 20" unitCodeListAgencyName="United Nations Economic Commission forEurope">'.$data['detalle'][$i]['cantidad'].'</cbc:InvoicedQuantity>'
                .'<cbc:LineExtensionAmount currencyID="PEN">'.$data['detalle'][$i]['subtotal'].'</cbc:LineExtensionAmount>'

                .'<cac:PricingReference>'
                  .'<cac:AlternativeConditionPrice>'
                    .'<cbc:PriceAmount currencyID="PEN">'.$data['detalle'][$i]['precio_unitario'].'</cbc:PriceAmount>'
                    .'<cbc:PriceTypeCode listName="SUNAT:Indicador de Tipo de Precio" listAgencyName="PE:SUNAT" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo16">01</cbc:PriceTypeCode>'
                  .'</cac:AlternativeConditionPrice>'
                .'</cac:PricingReference>'

                .'<cac:TaxTotal>'
                  .'<cbc:TaxAmount currencyID="PEN">'.$data['detalle'][$i]['impuesto'].'</cbc:TaxAmount>'
                  .'<cac:TaxSubtotal>'
                    .'<cbc:TaxableAmount currencyID="PEN">'.$data['detalle'][$i]['subtotal'].'</cbc:TaxableAmount>'
                    .'<cbc:TaxAmount currencyID="PEN">'.$data['detalle'][$i]['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxCategory>'
                      .'<cbc:ID schemeID="UN/ECE 5305" schemeName="Tax Category Identifier" schemeAgencyName="United Nations Economic Commission for Europe">S</cbc:ID>'
                      .'<cbc:Percent>'.$data['detalle'][$i]['valor_impuesto'].'</cbc:Percent>'
                      .'<cbc:TaxExemptionReasonCode listAgencyName="PE:SUNAT" listName="SUNAT:Codigo de Tipo de Afectación del IGV" listURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo07">10</cbc:TaxExemptionReasonCode>'
                      .'<cac:TaxScheme>'
                        .'<cbc:ID schemeID="UN/ECE 5153" schemeName="Tax Scheme Identifier" schemeAgencyName="United Nations Economic Commission for Europe">1000</cbc:ID>'
                        .'<cbc:Name>IGV</cbc:Name>'
                        .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                      .'</cac:TaxScheme>'
                    .'</cac:TaxCategory>'
                  .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'

                .'<cac:Item>'
                  .'<cbc:Description><![CDATA['.$data['detalle'][$i]['descripcion'].']]></cbc:Description>'
                .'</cac:Item>'
                .'<cac:Price>'
                  .'<cbc:PriceAmount currencyID="PEN">'.$data['detalle'][$i]['precio_unitario_neto'].'</cbc:PriceAmount>'
                .'</cac:Price>'

            .'</cac:InvoiceLine>';
        }

        $invoice.='</Invoice>';

        $nombreFactura = $data['archivo'];
        $fichero=fopen(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 'w');
        fwrite($fichero, $invoice);
        fclose($fichero);
        chmod( base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 0777);
    }

    /*****************************************************************************************************************/
    /* CREAR NOTA DE CREDITO XML
    /*****************************************************************************************************************/
     function crearNotaCreditoXML(array $data) 
    {
        $invoice='<?xml version="1.0" encoding="UTF-8"?>'
            .'<CreditNote xmlns="urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2"
                        xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
                        xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
                        xmlns:ccts="urn:un:unece:uncefact:documentation:2"
                        xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
                        xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
                        xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
                        xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1"
                        xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
                        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">'

                .'<ext:UBLExtensions>'
                    .'<ext:UBLExtension>'
                      .'<ext:ExtensionContent>'
                      .'</ext:ExtensionContent>'
                    .'</ext:UBLExtension>'
                .'</ext:UBLExtensions>'

                .'<cbc:UBLVersionID>2.1</cbc:UBLVersionID>'
                .'<cbc:CustomizationID>2.0</cbc:CustomizationID>'
                .'<cbc:ID>'.$data['nota']['nombre'].'</cbc:ID>'
                .'<cbc:IssueDate>'.$data['nota']['fecha'].'</cbc:IssueDate>'
                .'<cbc:IssueTime>'.$data['nota']['hora'].'</cbc:IssueTime>'
                //.'<cbc:Note languageLocaleID="3000">0501002017062500125</cbc:Note>'
                .'<cbc:DocumentCurrencyCode>PEN</cbc:DocumentCurrencyCode>'

                .'<cac:DiscrepancyResponse>'
                    .'<cbc:ReferenceID>'.$data['comprobante']['nombre'] .'</cbc:ReferenceID>'
                    .'<cbc:ResponseCode>'.$data['nota']['id_motivo'].'</cbc:ResponseCode>'
                    .'<cbc:Description><![CDATA['.$data['nota']['descripcion'].']]></cbc:Description>'
                .'</cac:DiscrepancyResponse>'

                .'<cac:BillingReference>'
                    .'<cac:InvoiceDocumentReference>'
                      .'<cbc:ID>'.$data['comprobante']['nombre'].'</cbc:ID>'
                      .'<cbc:DocumentTypeCode>'.$data['comprobante']['tipo_comprobante'].'</cbc:DocumentTypeCode>'
                    .'</cac:InvoiceDocumentReference>'
                .'</cac:BillingReference>'

               .'<cac:Signature>'
                    .'<cbc:ID>IDSignKG</cbc:ID>'
                    .'<cac:SignatoryParty>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID>'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                      .'</cac:PartyName>'
                    .'</cac:SignatoryParty>'
                    .'<cac:DigitalSignatureAttachment>'
                      .'<cac:ExternalReference>'
                        .'<cbc:URI>#SignatureKG</cbc:URI>'
                      .'</cac:ExternalReference>'
                    .'</cac:DigitalSignatureAttachment>'
                .'</cac:Signature>'     

                .'<cac:AccountingSupplierParty>'
                    .'<cac:Party>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID schemeID="6" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                     .'</cac:PartyName>'
                      .'<cac:PartyLegalEntity>'
                        .'<cbc:RegistrationName><![CDATA['.$data['empresa']['razon_social'].']]></cbc:RegistrationName>'
                        .'<cac:RegistrationAddress>'
                          .'<cbc:AddressTypeCode>0001</cbc:AddressTypeCode>'
                        .'</cac:RegistrationAddress>'
                      .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingSupplierParty>'

                .'<cac:AccountingCustomerParty>'
                    .'<cac:Party>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID schemeID="'.$data['comprobante']['tipo_doc_cliente'].'" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$data['comprobante']['num_doc_cliente'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyLegalEntity>'
                        .'<cbc:RegistrationName><![CDATA['.$data['comprobante']['nombre_cliente'].']]></cbc:RegistrationName>'
                      .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingCustomerParty>'

                .'<cac:TaxTotal>'
                    .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxSubtotal>'
                      .'<cbc:TaxableAmount currencyID="PEN">'.$data['comprobante']['subtotal'].'</cbc:TaxableAmount>'
                      .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                      .'<cac:TaxCategory>'
                        .'<cac:TaxScheme>'
                          .'<cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">1000</cbc:ID>'
                          .'<cbc:Name>IGV</cbc:Name>'
                          .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                        .'</cac:TaxScheme>'
                      .'</cac:TaxCategory>'
                    .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'

                .'<cac:LegalMonetaryTotal>'
                    .'<cbc:PayableAmount currencyID="PEN">'.$data['comprobante']['total'].'</cbc:PayableAmount>'
                .'</cac:LegalMonetaryTotal>';

        for ($i=0; $i < sizeof($data['detalle']) ; $i++) {   
            $invoice.= '<cac:CreditNoteLine>'
                .'<cbc:ID>'.($i+1).'</cbc:ID>'

                .'<cbc:CreditedQuantity unitCode="NIU">'.$data['detalle'][$i]['cantidad'].'</cbc:CreditedQuantity>'
                .'<cbc:LineExtensionAmount currencyID="PEN">'.$data['detalle'][$i]['subtotal'].'</cbc:LineExtensionAmount>'
                .'<cac:PricingReference>'
                  .'<cac:AlternativeConditionPrice>'
                    .'<cbc:PriceAmount currencyID="PEN">'.$data['detalle'][$i]['precio_unitario'] .'</cbc:PriceAmount>'
                    .'<cbc:PriceTypeCode>01</cbc:PriceTypeCode>'
                  .'</cac:AlternativeConditionPrice>'
                .'</cac:PricingReference>'

                .'<cac:TaxTotal>'
                  .'<cbc:TaxAmount currencyID="PEN">'.$data['detalle'][$i]['impuesto'].'</cbc:TaxAmount>'
                  .'<cac:TaxSubtotal>'
                    .'<cbc:TaxableAmount currencyID="PEN">'.$data['detalle'][$i]['subtotal'].'</cbc:TaxableAmount>'
                    .'<cbc:TaxAmount currencyID="PEN">'.$data['detalle'][$i]['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxCategory>'
                      .'<cbc:Percent>'.$data['detalle'][$i]['valor_impuesto'].'</cbc:Percent>'
                      .'<cbc:TaxExemptionReasonCode>10</cbc:TaxExemptionReasonCode>'
                      .'<cac:TaxScheme>'
                        .'<cbc:ID>1000</cbc:ID>'
                        .'<cbc:Name>IGV</cbc:Name>'
                        .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                      .'</cac:TaxScheme>'
                    .'</cac:TaxCategory>'
                  .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'

                .'<cac:Item>'
                  .'<cbc:Description><![CDATA['.$data['detalle'][$i]['descripcion'].']]></cbc:Description>'
                .'</cac:Item>'
                .'<cac:Price>'
                  .'<cbc:PriceAmount currencyID="PEN">'.$data['detalle'][$i]['precio_unitario_neto'].'</cbc:PriceAmount>'
                .'</cac:Price>'

            .'</cac:CreditNoteLine>';
        }

        $invoice.='</CreditNote>';   

        $nombreFactura = $data['archivo'];
        $fichero=fopen(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 'w');
        fwrite($fichero, $invoice);
        fclose($fichero);
        chmod( base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 0777);

    }

    /*****************************************************************************************************************/
    /* CREAR NOTA DE DEBITO XML
    /*****************************************************************************************************************/    

    function crearNotaDebitoXML(array $data) 
    {
        $invoice='<?xml version="1.0" encoding="UTF-8"?>'
            .'<DebitNote xmlns="urn:oasis:names:specification:ubl:schema:xsd:DebitNote-2"
                   xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
                   xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"
                   xmlns:ccts="urn:un:unece:uncefact:documentation:2"
                   xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
                   xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
                   xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2"
                   xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1"
                   xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
                   xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">'

                .'<ext:UBLExtensions>'
                    .'<ext:UBLExtension>'
                      .'<ext:ExtensionContent>'
                      .'</ext:ExtensionContent>'
                    .'</ext:UBLExtension>'
                .'</ext:UBLExtensions>'

                .'<cbc:UBLVersionID>2.1</cbc:UBLVersionID>'
                .'<cbc:CustomizationID>2.0</cbc:CustomizationID>'
                .'<cbc:ID>'.$data['nota']['nombre'].'</cbc:ID>'
                .'<cbc:IssueDate>'.$data['nota']['fecha'].'</cbc:IssueDate>'
                .'<cbc:IssueTime>'.$data['nota']['hora'].'</cbc:IssueTime>'
                //.'<cbc:Note languageLocaleID="3000">0501002017062500125</cbc:Note>'
                .'<cbc:DocumentCurrencyCode>PEN</cbc:DocumentCurrencyCode>'

                .'<cac:DiscrepancyResponse>'
                    .'<cbc:ReferenceID>'.$data['comprobante']['nombre'] .'</cbc:ReferenceID>'
                    .'<cbc:ResponseCode>'.$data['nota']['id_motivo'].'</cbc:ResponseCode>'
                    .'<cbc:Description><![CDATA['.$data['nota']['descripcion'].']]></cbc:Description>'
                .'</cac:DiscrepancyResponse>'

                .'<cac:BillingReference>'
                    .'<cac:InvoiceDocumentReference>'
                      .'<cbc:ID>'.$data['comprobante']['nombre'].'</cbc:ID>'
                      .'<cbc:DocumentTypeCode>'.$data['comprobante']['tipo_comprobante'].'</cbc:DocumentTypeCode>'
                    .'</cac:InvoiceDocumentReference>'
                .'</cac:BillingReference>'

               .'<cac:Signature>'
                    .'<cbc:ID>IDSignKG</cbc:ID>'
                    .'<cac:SignatoryParty>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID>'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                      .'</cac:PartyName>'
                    .'</cac:SignatoryParty>'
                    .'<cac:DigitalSignatureAttachment>'
                      .'<cac:ExternalReference>'
                        .'<cbc:URI>#SignatureKG</cbc:URI>'
                      .'</cac:ExternalReference>'
                    .'</cac:DigitalSignatureAttachment>'
                .'</cac:Signature>'     

                .'<cac:AccountingSupplierParty>'
                    .'<cac:Party>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID schemeID="6" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                     .'</cac:PartyName>'
                      .'<cac:PartyLegalEntity>'
                        .'<cbc:RegistrationName><![CDATA['.$data['empresa']['razon_social'].']]></cbc:RegistrationName>'
                        .'<cac:RegistrationAddress>'
                          .'<cbc:AddressTypeCode>0001</cbc:AddressTypeCode>'
                        .'</cac:RegistrationAddress>'
                      .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingSupplierParty>'

                .'<cac:AccountingCustomerParty>'
                    .'<cac:Party>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID schemeID="'.$data['comprobante']['tipo_doc_cliente'].'" schemeName="SUNAT:Identificador de Documento de Identidad" schemeAgencyName="PE:SUNAT" schemeURI="urn:pe:gob:sunat:cpe:see:gem:catalogos:catalogo06">'.$data['comprobante']['num_doc_cliente'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyLegalEntity>'
                        .'<cbc:RegistrationName><![CDATA['.$data['comprobante']['nombre_cliente'].']]></cbc:RegistrationName>'
                      .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingCustomerParty>'

                .'<cac:TaxTotal>'
                    .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxSubtotal>'
                      .'<cbc:TaxableAmount currencyID="PEN">'.$data['comprobante']['subtotal'].'</cbc:TaxableAmount>'
                      .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                      .'<cac:TaxCategory>'
                        .'<cac:TaxScheme>'
                          .'<cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">1000</cbc:ID>'
                          .'<cbc:Name>IGV</cbc:Name>'
                          .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                        .'</cac:TaxScheme>'
                      .'</cac:TaxCategory>'
                    .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'

                .'<cac:RequestedMonetaryTotal>'
                    .'<cbc:PayableAmount currencyID="PEN">'.$data['comprobante']['total'].'</cbc:PayableAmount>'
                .'</cac:RequestedMonetaryTotal>';

        for ($i=0; $i < 1 ; $i++) {      
            $invoice.= '<cac:DebitNoteLine>'
                .'<cbc:ID>'.($i+1).'</cbc:ID>'

                .'<cbc:DebitedQuantity unitCode="NIU">1</cbc:DebitedQuantity>'
                .'<cbc:LineExtensionAmount currencyID="PEN">'.$data['comprobante']['subtotal'].'</cbc:LineExtensionAmount>'

                .'<cac:PricingReference>'
                  .'<cac:AlternativeConditionPrice>'
                    .'<cbc:PriceAmount currencyID="PEN">'.$data['comprobante']['total'].'</cbc:PriceAmount>'
                    .'<cbc:PriceTypeCode>01</cbc:PriceTypeCode>'
                  .'</cac:AlternativeConditionPrice>'
                .'</cac:PricingReference>'

                .'<cac:TaxTotal>'
                  .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                  .'<cac:TaxSubtotal>'
                    .'<cbc:TaxableAmount currencyID="PEN">'.$data['comprobante']['subtotal'].'</cbc:TaxableAmount>'
                    .'<cbc:TaxAmount currencyID="PEN">'.$data['comprobante']['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxCategory>'
                      .'<cbc:Percent>'.$data['comprobante']['valor_impuesto'].'</cbc:Percent>' // OJO IMPUESTO 18.00 PUEDE CAMBIAR
                      .'<cbc:TaxExemptionReasonCode>10</cbc:TaxExemptionReasonCode>'
                      .'<cac:TaxScheme>'
                        .'<cbc:ID>1000</cbc:ID>'
                        .'<cbc:Name>IGV</cbc:Name>'
                        .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                      .'</cac:TaxScheme>'
                    .'</cac:TaxCategory>'
                  .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'

                .'<cac:Item>'
                  .'<cbc:Description><![CDATA['.$data['nota']['descripcion'].']]></cbc:Description>'
                .'</cac:Item>'
                .'<cac:Price>'
                  .'<cbc:PriceAmount currencyID="PEN">'.$data['comprobante']['subtotal'].'</cbc:PriceAmount>'
                .'</cac:Price>'

            .'</cac:DebitNoteLine>';
        }

        $invoice.='</DebitNote>';
        
        $nombreFactura = $data['archivo'];
        $fichero=fopen(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 'w');
        fwrite($fichero, $invoice);
        fclose($fichero);
        chmod( base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 0777);

    }

    /*****************************************************************************************************************/
    /* CREAR RESUMEN DIARIO DE BOLETAS XML
    /*****************************************************************************************************************/
    function crearResumenXML(array $data) 
    {
      $invoice='<?xml version="1.0" encoding="UTF-8"?>'
            .'<SummaryDocuments 
                xmlns="urn:sunat:names:specification:ubl:peru:schema:xsd:SummaryDocuments-1" 
                xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" 
                xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" 
                xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
                xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" 
                xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1" 
                xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" 
                xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" 
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">'  

                .'<ext:UBLExtensions>'
                    .'<ext:UBLExtension>'
                        .'<ext:ExtensionContent/>'
                    .'</ext:UBLExtension>'
                .'</ext:UBLExtensions>'

                .'<cbc:UBLVersionID>2.0</cbc:UBLVersionID>'
                .'<cbc:CustomizationID>1.1</cbc:CustomizationID>'
                .'<cbc:ID>'.$data['resumen']['nombre'].'</cbc:ID>'
                .'<cbc:ReferenceDate>'.$data['comprobante']['fecha'].'</cbc:ReferenceDate>'  
                .'<cbc:IssueDate>'.$data['resumen']['fecha'].'</cbc:IssueDate>'

                .'<cac:Signature>'
                    .'<cbc:ID>IDSignKG</cbc:ID>'
                    .'<cac:SignatoryParty>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID>'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                      .'</cac:PartyName>'
                    .'</cac:SignatoryParty>'
                    .'<cac:DigitalSignatureAttachment>'
                      .'<cac:ExternalReference>'
                        .'<cbc:URI>#signatureKG</cbc:URI>'
                      .'</cac:ExternalReference>'
                    .'</cac:DigitalSignatureAttachment>'
                .'</cac:Signature>'

                .'<cac:AccountingSupplierParty>'
                    .'<cbc:CustomerAssignedAccountID>'.$data['empresa']['ruc'].'</cbc:CustomerAssignedAccountID>'
                    .'<cbc:AdditionalAccountID>6</cbc:AdditionalAccountID>'
                    .'<cac:Party>'
                        .'<cac:PartyLegalEntity>'
                            .'<cbc:RegistrationName><![CDATA['.$data['empresa']['razon_social'].']]></cbc:RegistrationName>'
                        .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingSupplierParty>';

        for ($i=0; $i < sizeof($data['boleta']) ; $i++) {  
            $invoice.= '<sac:SummaryDocumentsLine>'
                .'<cbc:LineID>'.($i+1).'</cbc:LineID>'
                .'<cbc:DocumentTypeCode>'.$data['boleta'][$i]['tipo_comprobante'].'</cbc:DocumentTypeCode>'
                .'<cbc:ID>'.$data['boleta'][$i]['nombre'].'</cbc:ID>'
                .'<cac:AccountingCustomerParty>'
                    .'<cbc:CustomerAssignedAccountID>'.$data['boleta'][$i]['num_doc_cliente'].'</cbc:CustomerAssignedAccountID>'
                    .'<cbc:AdditionalAccountID>'.$data['boleta'][$i]['tipo_doc_cliente'].'</cbc:AdditionalAccountID>'
                .'</cac:AccountingCustomerParty>'
                .'<cac:Status>'
                    .'<cbc:ConditionCode>1</cbc:ConditionCode>'
                .'</cac:Status>'
                .'<sac:TotalAmount currencyID="PEN">'.$data['boleta'][$i]['total'].'</sac:TotalAmount>'
                .'<sac:BillingPayment>'
                    .'<cbc:PaidAmount currencyID="PEN">'.$data['boleta'][$i]['subtotal'].'</cbc:PaidAmount>'
                    .'<cbc:InstructionID>01</cbc:InstructionID>'
                .'</sac:BillingPayment>'

                .'<cac:TaxTotal>'
                    .'<cbc:TaxAmount currencyID="PEN">'.$data['boleta'][$i]['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxSubtotal>'
                        .'<cbc:TaxAmount currencyID="PEN">'.$data['boleta'][$i]['impuesto'].'</cbc:TaxAmount>'
                        .'<cac:TaxCategory>'
                            .'<cac:TaxScheme>'
                                .'<cbc:ID>1000</cbc:ID>'
                                .'<cbc:Name>IGV</cbc:Name>'
                                .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                            .'</cac:TaxScheme>'
                        .'</cac:TaxCategory>'
                    .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'
              .'</sac:SummaryDocumentsLine>';
        }

        $invoice.='</SummaryDocuments>';

        $nombreFactura = $data['archivo'];
        $fichero=fopen(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 'w');
        fwrite($fichero, $invoice);
        fclose($fichero);
        chmod( base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 0777);

    }

    /*****************************************************************************************************************/
    /* CREAR RESUMEN DIARIO DE NOTAS DE CREDITO
    /*****************************************************************************************************************/
    function crearResumenNota(array $data) 
    {
        $invoice='<?xml version="1.0" encoding="iso-8859-1" standalone="no"?>'
            .'<SummaryDocuments 
                xmlns="urn:sunat:names:specification:ubl:peru:schema:xsd:SummaryDocuments-1" 
                xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" 
                xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" 
                xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
                xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" 
                xmlns:sac="urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1"
                xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" 
                xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">'

                .'<ext:UBLExtensions>'
                    .'<ext:UBLExtension>'
                        .'<ext:ExtensionContent/>'
                    .'</ext:UBLExtension>'
                .'</ext:UBLExtensions>'

                .'<cbc:UBLVersionID>2.0</cbc:UBLVersionID>'
                .'<cbc:CustomizationID>1.1</cbc:CustomizationID>'
                .'<cbc:ID>'.$data['resumen']['nombre'].'</cbc:ID>'
                .'<cbc:ReferenceDate>'.$data['comprobante']['fecha'].'</cbc:ReferenceDate>'  
                .'<cbc:IssueDate>'.$data['resumen']['fecha'].'</cbc:IssueDate>'

                .'<cac:Signature>'
                    .'<cbc:ID>IDSignKG</cbc:ID>'
                    .'<cac:SignatoryParty>'
                      .'<cac:PartyIdentification>'
                        .'<cbc:ID>'.$data['empresa']['ruc'].'</cbc:ID>'
                      .'</cac:PartyIdentification>'
                      .'<cac:PartyName>'
                        .'<cbc:Name><![CDATA['.$data['empresa']['razon_social'].']]></cbc:Name>'
                      .'</cac:PartyName>'
                    .'</cac:SignatoryParty>'
                    .'<cac:DigitalSignatureAttachment>'
                      .'<cac:ExternalReference>'
                        .'<cbc:URI>#signatureKG</cbc:URI>'
                      .'</cac:ExternalReference>'
                    .'</cac:DigitalSignatureAttachment>'
                .'</cac:Signature>'

                .'<cac:AccountingSupplierParty>'
                    .'<cbc:CustomerAssignedAccountID>'.$data['empresa']['ruc'].'</cbc:CustomerAssignedAccountID>'
                    .'<cbc:AdditionalAccountID>6</cbc:AdditionalAccountID>'
                    .'<cac:Party>'
                      .'<cac:PartyLegalEntity>'
                        .'<cbc:RegistrationName><![CDATA['.$data['empresa']['razon_social'].']]></cbc:RegistrationName>'
                      .'</cac:PartyLegalEntity>'
                    .'</cac:Party>'
                .'</cac:AccountingSupplierParty>';

        for ($i=0; $i < sizeof($data['boleta']) ; $i++) {  
            $invoice.= '<sac:SummaryDocumentsLine>'
                .'<cbc:LineID>'.($i+1).'</cbc:LineID>'
                .'<cbc:DocumentTypeCode>'.$data['nota'][$i]['tipo_comprobante'].'</cbc:DocumentTypeCode>' //Nota de Credito 07
                .'<cbc:ID>'.$data['nota'][$i]['nombre'].'</cbc:ID>' //Nombre de la  nota
                .'<cac:AccountingCustomerParty>'
                  .'<cbc:CustomerAssignedAccountID>'.$data['boleta'][$i]['num_doc_cliente'].'</cbc:CustomerAssignedAccountID>'
                  .'<cbc:AdditionalAccountID>'.$data['boleta'][$i]['tipo_doc_cliente'].'</cbc:AdditionalAccountID>'
                .'</cac:AccountingCustomerParty>'
                .'<cac:BillingReference>'
                    .'<cac:InvoiceDocumentReference>'
                        .'<cbc:ID>'.$data['boleta'][$i]['nombre'].'</cbc:ID>'  //Nombre de la boleta afectado
                        .'<cbc:DocumentTypeCode>'.$data['boleta'][$i]['tipo_comprobante'].'</cbc:DocumentTypeCode>' // 03 boleta
                    .'</cac:InvoiceDocumentReference>'
                .'</cac:BillingReference>'
                .'<cac:Status>'
                  .'<cbc:ConditionCode>1</cbc:ConditionCode>'
                .'</cac:Status>'
                .'<sac:TotalAmount currencyID="PEN">'.$data['boleta'][$i]['total'].'</sac:TotalAmount>'
                .'<sac:BillingPayment>'
                  .'<cbc:PaidAmount currencyID="PEN">'.$data['boleta'][$i]['subtotal'].'</cbc:PaidAmount>'
                  .'<cbc:InstructionID>01</cbc:InstructionID>'
                .'</sac:BillingPayment>'
                .'<cac:TaxTotal>'
                  .'<cbc:TaxAmount currencyID="PEN">'.$data['boleta'][$i]['impuesto'].'</cbc:TaxAmount>'
                  .'<cac:TaxSubtotal>'
                    .'<cbc:TaxAmount currencyID="PEN">'.$data['boleta'][$i]['impuesto'].'</cbc:TaxAmount>'
                    .'<cac:TaxCategory>'
                      .'<cac:TaxScheme>'
                        .'<cbc:ID>1000</cbc:ID>'
                        .'<cbc:Name>IGV</cbc:Name>'
                        .'<cbc:TaxTypeCode>VAT</cbc:TaxTypeCode>'
                      .'</cac:TaxScheme>'
                    .'</cac:TaxCategory>'
                  .'</cac:TaxSubtotal>'
                .'</cac:TaxTotal>'
              .'</sac:SummaryDocumentsLine>';
        }

        $invoice.='</SummaryDocuments>';

        $nombreFactura = $data['archivo'];
        $fichero=fopen(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 'w');
        fwrite($fichero, $invoice);
        fclose($fichero);
        chmod( base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 0777);

    }

    /*****************************************************************************************************************/
    /* FIRMAR XML
    /*****************************************************************************************************************/
    function firmarComprobante(array $data)
    {
        $nombreFactura = $data['archivo'];
        $doc = new DOMDocument();
        $doc->load(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml");
        $objDSig = new XMLSecurityDSig();
        $objDSig->setCanonicalMethod(XMLSecurityDSig::EXC_C14N);
        $objDSig->addReference(
            $doc,
            XMLSecurityDSig::SHA1,
            array('http://www.w3.org/2000/09/xmldsig#enveloped-signature'),
            array('force_uri' => true)
        );
        $objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA1, array('type' => 'private'));
        $objKey->loadKey(base_path()."/sunat/credenciales/llaves/private_key.pem", true);
        $objDSig->sign($objKey); 
        $objDSig->add509Cert(file_get_contents(base_path()."/sunat/credenciales/llaves/public_key.pem"), true, false, array('subjectName' => true)); 
        $objDSig->appendSignature($doc->getElementsByTagName('ExtensionContent')->item(0));
        $doc->save(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml");
        chmod(base_path()."/sunat/xml/".$data['carpeta']."/".$nombreFactura.".xml", 0777);
    }

    /*****************************************************************************************************************/
    /* COMPRIMIR XML
    /*****************************************************************************************************************/
    function comprimirComprobante(array $data) 
    {
        $NomArch = base_path()."/sunat/xml/".$data['carpeta']."/".$data['archivo'];
        if (file_exists($NomArch.".zip")) {
            unlink($NomArch.".zip"); 
        } 
        $zip = new PclZip($NomArch.".zip");
        $zip->add($NomArch.".xml", PCLZIP_OPT_REMOVE_PATH, base_path()."/sunat/xml/".$data['carpeta']."/");
        chmod($NomArch.".zip", 0777);  
    }

    /*****************************************************************************************************************/
    /* ENVIAR XML
    /*****************************************************************************************************************/
    function enviarComprobante(array $data) 
    {
        $NomArch = $data['archivo'];
        $rutaArch = base_path()."/sunat/xml/".$data['carpeta']."/".$NomArch;

        //Estructura del XML para la conexión OJOOO UsernameToken CLAVE SOL
        $XMLString = '<?xml version="1.0" encoding="UTF-8"?>
        <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
         <soapenv:Header>
             <wsse:Security>
                 <wsse:UsernameToken>
                     <wsse:Username>'.$data['empresa']['ruc'].''.env("USUARIO_SECUNDARIO").'</wsse:Username>
                     <wsse:Password>'.env("PASSWORD_SECUNDARIO").'</wsse:Password>
                 </wsse:UsernameToken>
             </wsse:Security>
         </soapenv:Header>
         <soapenv:Body>
             <ser:sendBill>
                <fileName>'.$NomArch.'.zip</fileName>
                <contentFile>'.base64_encode(file_get_contents($rutaArch.'.zip')).'</contentFile>
             </ser:sendBill>
         </soapenv:Body>
        </soapenv:Envelope>';

        try {
            if ($data['carpeta'] == "guias") {
              $result = soapCall(wsdlURL_Guia(), $callFunction = "sendBill", $XMLString);
            }
            else {
              $result = soapCall(wsdlURL(), $callFunction = "sendBill", $XMLString);
            }
   
            //Descargamos el Archivo Response
            $archivo = fopen(base_path()."/sunat/cdr/".$data['carpeta']."/C".$NomArch.".xml","w+");
            fputs($archivo, $result);
            fclose($archivo);
            //LEEMOS EL ARCHIVO XML
            $xml = simplexml_load_file(base_path()."/sunat/cdr/".$data['carpeta']."/C".$NomArch.".xml"); 
            foreach ($xml->xpath('//applicationResponse') as $response){ }
            //AQUI DESCARGAMOS EL ARCHIVO CDR(CONSTANCIA DE RECEPCIÓN)
            $cdr=base64_decode($response);
            $archivo = fopen(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".zip","w+");
            fputs($archivo,$cdr);
            fclose($archivo);
            chmod(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".zip", 0777);
            //Descomprimimos respuesta de SUNAT
            $archive = new PclZip(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".zip");
            if ($archive->extract(PCLZIP_OPT_PATH, "../sunat/cdr/".$data['carpeta']."")==0){ // por defecto extrae en la carpeta public, por redirigimos asi
                die("Error : ".$archive->errorInfo(true)); 
            }else{
                chmod(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".xml", 0777);    
            } 
            //Eliminamos el Archivo Response
            unlink(base_path()."/sunat/cdr/".$data['carpeta']."/C".$NomArch.".xml");
            $data['respuesta'] = "ENVIADO";
            return $data;
        } catch (SoapFault $fault) {
            if ($fault->faultcode == "soap-env:Client.1032" || $fault->faultcode == "soap-env:Client.1033") {
                $data = consultaCdrComprobante($data);
                return $data;
            }
            else
            {
                $data['respuesta'] = "NO ENVIADO";
                $data['mensaje'] = "ERROR (".$fault->faultcode."): ".$fault->faultstring;
                $data['estado'] = "NO ENVIADO";
                return $data;
            }
        }
    }

    function enviarResumen(array $data) 
    {
        $NomArch = $data['archivo'];
        $rutaArch = base_path()."/sunat/xml/".$data['carpeta']."/".$NomArch;

        //Estructura del XML para la conexión OJOOO UsernameToken CLAVE SOL
        $XMLString='<?xml version="1.0" encoding="UTF-8"?>
        <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
         <soapenv:Header>
             <wsse:Security>
                 <wsse:UsernameToken>
                     <wsse:Username>'.$data['empresa']['ruc'].''.env("USUARIO_SECUNDARIO").'</wsse:Username>
                     <wsse:Password>'.env("PASSWORD_SECUNDARIO").'</wsse:Password>
                 </wsse:UsernameToken>
             </wsse:Security>
         </soapenv:Header>
         <soapenv:Body>
             <ser:sendSummary>
                <fileName>'.$NomArch.'.zip</fileName>
                <contentFile>'.base64_encode(file_get_contents($rutaArch.'.zip')).'</contentFile>
             </ser:sendSummary>
         </soapenv:Body>
        </soapenv:Envelope>';

        try {
            $result = soapCall( wsdlURL(), $callFunction = "sendSummary", $XMLString);
            //Descargamos el Archivo Response
            $responseFile=fopen(base_path()."/sunat/tickets/T-".$NomArch.".xml", "w+");
            fwrite($responseFile, $result);
            fclose($responseFile);

            $data['mensaje'] = "El comprobante fue enviado correctamente";
            $data['estado'] = "PENDIENTE";
            return $data;
        } catch (SoapFault $fault) {
            $data['mensaje'] = "ERROR (".$fault->faultcode."): ".$fault->faultstring;
            $data['estado'] = "NO ENVIADO";
            return $data;
        }
    }


    /*****************************************************************************************************************/
    /* CONSULTA DE TICKETS
    /*****************************************************************************************************************/

    function consultaTicketResumen(array $data) 
    {
        $NomArch = $data['archivo'];
        $rutaArch = base_path()."/sunat/xml/".$data['carpeta']."/".$NomArch;

        //Extraemos el codigo del ticket
        $xml = simplexml_load_file(base_path().'/sunat/tickets/T-'.$NomArch.'.xml'); 
        foreach ($xml->xpath('//ticket') as $ticketNro){ } 
            
        $XMLString='<?xml version="1.0" encoding="UTF-8"?>
        <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://service.sunat.gob.pe" xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
         <soapenv:Header>
             <wsse:Security>
                 <wsse:UsernameToken>
                     <wsse:Username>'.$data['empresa']['ruc'].''.env("USUARIO_SECUNDARIO").'</wsse:Username>
                     <wsse:Password>'.env("PASSWORD_SECUNDARIO").'</wsse:Password>
                 </wsse:UsernameToken>
             </wsse:Security>
         </soapenv:Header>
         <soapenv:Body>
             <ser:getStatus>
                <ticket>'.$ticketNro.'</ticket>
             </ser:getStatus>
         </soapenv:Body>
        </soapenv:Envelope>';    

        try {    
            $result=soapCall(wsdlURL(), $callFunction='getStatus', $XMLString);
            $responseFile=fopen(base_path().'/sunat/tickets/C'.$NomArch.'.xml', 'w+');
            fwrite($responseFile, $result);
            fclose($responseFile);

            //Extraemos la respuesta del ticket
            $xml = simplexml_load_file(base_path().'/sunat/tickets/C'.$NomArch.'.xml'); 
            foreach ($xml->xpath('//status/content') as $response){ }
                
            $cdr=base64_decode($response);
            $archivo = fopen(base_path().'/sunat/tickets/R'.$NomArch.'.zip','w+');
            fputs($archivo,$cdr);
            fclose($archivo);
            chmod(base_path().'/sunat/tickets/R'.$NomArch.'.zip', 0777);

            //Descomprimimos respuesta de SUNAT
            $extract = new ZipArchive();
            $extract->open(base_path().'/sunat/tickets/R'.$NomArch.'.zip');
            $extract->extractTo(base_path()."/sunat/cdr/".$data['carpeta']."/");
            $extract->close();

            //Eliminamos el Archivo Response
            unlink(base_path().'/sunat/tickets/C'.$NomArch.'.xml');
            unlink(base_path().'/sunat/tickets/R'.$NomArch.'.zip');

            $data['respuesta'] = "ENVIADO";
            return $data;
        } catch (SoapFault $fault) {
            $data['respuesta'] = "NO ENVIADO";
            $data['mensaje'] = "ERROR (".$fault->faultcode."): ".$fault->faultstring;
            $data['estado'] = "NO ENVIADO";
            return $data;
        }
    }

    /*****************************************************************************************************************/
    /* CONSULTA DE CDR
    /*****************************************************************************************************************/

    function consultaCdrComprobante(array $data) 
    {
        $NomArch = $data['archivo']; 

        $XMLString='<?xml version="1.0" encoding="UTF-8"?>
            <soapenv:Envelope 
                xmlns:ser="http://service.sunat.gob.pe" 
                xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
                xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
                <soapenv:Header>
                  <wsse:Security>
                     <wsse:UsernameToken>
                        <wsse:Username>'.$data['empresa']['ruc'].''.env("USUARIO_SECUNDARIO").'</wsse:Username>
                        <wsse:Password>'.env("PASSWORD_SECUNDARIO").'</wsse:Password>
                     </wsse:UsernameToken>
                  </wsse:Security>
               </soapenv:Header>
               <soapenv:Body>
                  <ser:getStatusCdr>
                     <rucComprobante>'.$data['empresa']['ruc'].'</rucComprobante>
                     <tipoComprobante>'.$data['comprobante']['tipo_comprobante'].'</tipoComprobante>
                     <serieComprobante>'.$data['comprobante']['serie'].'</serieComprobante>
                     <numeroComprobante>'.$data['comprobante']['numero'].'</numeroComprobante>
                  </ser:getStatusCdr>
               </soapenv:Body>
            </soapenv:Envelope>';  

        try {
            $result=soapCall(wsdlURL_Cdr(), $callFunction='getStatusCdr', $XMLString);
            //Descargamos el Archivo Response
            $archivo = fopen(base_path()."/sunat/cdr/".$data['carpeta']."/C".$NomArch.".xml","w+");
            fputs($archivo, $result);
            fclose($archivo);
            //LEEMOS EL ARCHIVO XML
            $xml = simplexml_load_file(base_path()."/sunat/cdr/".$data['carpeta']."/C".$NomArch.".xml"); 
            foreach ($xml->xpath('//statusCdr/content') as $response){ }
            //AQUI DESCARGAMOS EL ARCHIVO CDR(CONSTANCIA DE RECEPCIÓN)
            $cdr=base64_decode($response);
            $archivo = fopen(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".zip","w+");
            fputs($archivo,$cdr);
            fclose($archivo);
            chmod(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".zip", 0777);
            //Descomprimimos respuesta de SUNAT
            $archive = new PclZip(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".zip");
            if ($archive->extract(PCLZIP_OPT_PATH, "../sunat/cdr/".$data['carpeta']."")==0) { // por defecto extrae en la carpeta public, por redirigimos asi
                die("Error : ".$archive->errorInfo(true)); 
            }else{
                chmod(base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch.".xml", 0777);    
            } 
            //Eliminamos el Archivo Response
            unlink(base_path()."/sunat/cdr/".$data['carpeta']."/C".$NomArch.".xml");
            $data['respuesta'] = "ENVIADO";
            return $data;
        } catch (SoapFault $fault) {
            $data['respuesta'] = "NO ENVIADO";
            $data['mensaje'] = "ERROR (".$fault->faultcode."): ".$fault->faultstring;
            $data['estado'] = "NO ENVIADO";
            return $data;
        }   
  
    }
    /*****************************************************************************************************************/
    /* RESPUESTA DE SUNAT
    /*****************************************************************************************************************/
    function respuestaComprobante(array $data) 
    {
        //Extraemos la respuesta del Servidor
        $NomArch = $data['archivo'];
        $rutaArch = base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch;
        $xml = file_get_contents($rutaArch.'.xml');
        $DOM = new DOMDocument('1.0', 'ISO-8859-1');
        $DOM->preserveWhiteSpace = FALSE;
        $DOM->loadXML($xml);
        $DocXML = $DOM->getElementsByTagName('ResponseCode');
        foreach($DocXML as $Nodo){
            $codigo = $Nodo->nodeValue; 
        }  
        $DocXML = $DOM->getElementsByTagName('Description');
        foreach($DocXML as $Nodo){
            $mensaje = $Nodo->nodeValue; 
        }    
        if ($codigo == 0) {
            $data['estado'] = 'ACEPTADO'; //ACEPTADO| RECHAZADO 
        }
        else {
            $data['estado'] = 'RECHAZADO'; //ACEPTADO| RECHAZADO
        }
        $data['mensaje'] =  $mensaje; //Description 
        return $data;
    }

    function respuestaResumen(array $data) 
    {
        //Extraemos la respuesta del Servidor
        $NomArch = $data['archivo'];
        $rutaArch = base_path()."/sunat/cdr/".$data['carpeta']."/R-".$NomArch;
        $xml = file_get_contents($rutaArch.'.xml');
        $DOM = new DOMDocument('1.0', 'ISO-8859-1');
        $DOM->preserveWhiteSpace = FALSE;
        $DOM->loadXML($xml);
        $DocXML = $DOM->getElementsByTagName('ResponseCode');
        foreach($DocXML as $Nodo){
            $codigo = $Nodo->nodeValue; 
        }  
        $DocXML = $DOM->getElementsByTagName('Description');
        foreach($DocXML as $Nodo){
            $mensaje = $Nodo->nodeValue; 
        }    
        if ($codigo == 0) {
            $data['estado'] = 'ACEPTADO'; //ACEPTADO| RECHAZADO 
            $data['mensaje'] =  $mensaje; //Description 
        }
        else {
            if ($codigo == 2223) {
                $data['estado'] = 'ACEPTADO'; 
                $data['mensaje'] =  $mensaje .' ('. $codigo .')'; //Resumen ya enviado
            }
            else{
                $data['estado'] = 'RECHAZADO'; 
                $data['mensaje'] =  $mensaje .' ('. $codigo .')'; //Description     
            }
        }
        return $data;
    }