<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Cliente;
use App\Models\TipoDocumento;

class ClienteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function nuevo()
    {
	 	return view('cliente.nuevo', [ 'tipo_documento' => TipoDocumento::all() ]); 
	}

	public function listar()
    {
	 	$res = Cliente::where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        return view('cliente.listar', [ 'data' => $res]); 
	}

    public function existeCampo(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Cliente::where($request->campo, '=', $request->valor)->count();
            }
            
            return response()->json($val); 
        }
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $res = Cliente::create($request->all());
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

	public function editar($id)
    {
        return view('cliente.editar', [
            'data' => Cliente::where(['id_cliente' => $id , 'estado' => 1])->first(), 
            'tipo_documento' => TipoDocumento::all() 
        ]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Cliente::find($request->id_cliente);

            $data->nombre             	= $request->nombre; 
            $data->id_tipo_documento 	= $request->id_tipo_documento;
            $data->numero_documento 	= $request->numero_documento;
            $data->direccion          	= $request->direccion;
            $data->telefono           	= $request->telefono;
            $data->email                = $request->email;

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
    	if ($request->ajax())
        {
	      	$data = Cliente::find($request->id_cliente);
            $data->estado = 0;
            $res  = $data->save();
	    
	        return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
    	}
    }

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = Cliente::with(['tipo_documento'])->find($request->id_cliente);
            return response()->json($res);  
        }
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id = TipoDocumento::where('nombre', 'LIKE', '%'.$request->search.'%')->first();

            $res =  Cliente::with(['tipo_documento'])->where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request, $id) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('numero_documento', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('direccion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('telefono', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('id_tipo_documento', '=', $id ? $id->id_tipo_documento : '');
                    })->paginate(10);

            $res->appends(['search' => $request->search]); 
            return view('cliente.listar', ['data' => $res]); 
        }
    }

    public function getByDocumento(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->numero_documento))
            {
                $res = Cliente::where('numero_documento', $request->numero_documento)->first();
            }
            return response()->json($res);  
        }
    }




    public function getDniByApi(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->numero_documento))
            {
                $url = 'http://api.soft.pe/personas/buscar.php?dni=';

                if (!@file_get_contents($url) === false)
                {
                    $consulta = file_get_contents($url.$request->numero_documento);
                    $output= json_decode($consulta, true);
                    if( $output['success'] == true )
                    {
                        $res = [
                            'nombres' => $output['result']['nombre'],
                            'apellido_paterno' => $output['result']['paterno'],
                            'apellido_materno' => $output['result']['materno'],
                            'nombre' => $output['result']['nombre'].' '.$output['result']['paterno'].' '.$output['result']['materno'],
                            'genero' => "",
                            'fecha_nacimiento' => "",
                        ];
                    }
                }
                else {
                    $res = Cliente::where('numero_documento', $request->numero_documento)->first();
                }      
            }
            return response()->json($res);  
        }
    }
    
    
    /*
    public function getDniByApi(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->numero_documento))
            {
                $url = 'http://api.soft.pe/personas/buscar.php?dni=';
                if (!@file_get_contents($url) === false)
                {
                    $consulta = file_get_contents($url.$request->numero_documento);
                    $output= json_decode($consulta, true);
                    if( $output['success'] == true )
                    {
                        $res = [
                            'nombres' => $output['result']['nombre'],
                            'apellido_paterno' => $output['result']['paterno'],
                            'apellido_materno' => $output['result']['materno'],
                            'nombre' => $output['result']['nombre'].' '.$output['result']['paterno'].' '.$output['result']['materno'],
                            'genero' => "",
                            'fecha_nacimiento' => "",
                        ];
                    }
                }
                else {
                    $res = Cliente::where('numero_documento', $request->numero_documento)->first();
                }      
            }
            return response()->json($res);  
        }
    }
    */
    
    


  
    public function getRucByApi(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->numero_documento))
            {
                $url = 'http://api.soft.pe/sunat/buscar.php?ruc=';
                if (!@file_get_contents($url) === false) 
                {     
                    $consulta = file_get_contents($url.$request->numero_documento);
                    $output= json_decode($consulta, true);
                    if($output['success'] == true)
                    {
                        $res = [
                            'nombre' => $output['result']['razon_social'],
                            'direccion' => $output['result']['direccion'],
                        ];
                    }
                }
                else {
                    $res = Cliente::where('numero_documento', $request->numero_documento)->first();
                } 
            }
            return response()->json($res);  
        }
    }
    
    
    
    

    public function getByNombre(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->search))
            {
                $res =  Cliente::with(['tipo_documento'])->where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('numero_documento', 'LIKE',  '%'.$request->search.'%');
                    })->orderBy('nombre', 'ASC')->get();
            }
            return response()->json($res); 
        }
    }
}
