<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Venta;
use App\Models\DetalleVenta;
use App\Models\Empresa;
use App\Models\Nota;


class ElectronicoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function listar_facturas()
    {
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 1)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 1)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('electronico.listar_facturas', [ 'data' => $res]); 
    }

    public function estado_facturas($id)
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'REGISTRADO'];

        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 1)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 1)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('electronico.listar_facturas', [ 'data' => $res]); 
    }

    public function detalles($id)
    {
        return view('electronico.detalles', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where(['id_venta' => $id , 'estado' => 1])->first(),
            'empresa' => Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first(),
            'detalle_venta' => DetalleVenta::where(['id_venta' => $id , 'estado' => 1])->get(),
        ]); 
    }

    public function listar_boletas()
    {
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 2)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 2)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('electronico.listar_boletas', [ 'data' => $res]); 
    }

    public function estado_boletas($id)
    {
        //$estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'REGISTRADO'];

        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'PENDIENTE', 'REGISTRADO'];

        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 2)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_cliente', '<>', null)->where('id_tipo_comprobante', 2)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('electronico.listar_boletas', [ 'data' => $res]); 
    }






}