<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Empresa;

class EmpresaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function nuevo()
    {
	 	return view('empresa.nuevo'); 
	}

	/*public function listar()
    {
	 	$res = Proveedor::where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        return view('proveedor.listar', [ 'data' => $res]); 
	}*/

    public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $res = Empresa::create($request->all());
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }

    public function editar($id)
    {
        return view('empresa.editar', ['data' => Empresa::where(['id_empresa' => $id , 'estado' => 1])->first()]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Empresa::find($request->id_empresa);

            $data->razon_social     = $request->razon_social; 
            $data->ruc              = $request->ruc;
            $data->representante    = $request->representante;
            $data->dni              = $request->dni;
            $data->autorizacion     = $request->autorizacion;
            $data->direccion        = $request->direccion;
            $data->telefono         = $request->telefono;
            $data->pagina_web       = $request->pagina_web;
            $data->email            = $request->email;
            $data->ubigeo           = $request->ubigeo;
            $data->valor_impuesto   = $request->valor_impuesto;

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function envios()
    {
        return view('empresa.envios'); 
    }



}
