<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Habitacion;
use App\Models\TipoHabitacion;

class HabitacionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function nuevo()
    {
	 	return view('habitacion.nuevo', [ 'tipo_habitacion' => TipoHabitacion::all() ]); 
	}

	public function listar()
    {
	 	$res = Habitacion::where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get();
        return view('habitacion.listar', [ 'data' => $res]); 
	}

    public function existeCampo(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Habitacion::where($request->campo, '=', $request->valor)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->count();
            }
            
            return response()->json($val); 
        }
    }

    public function existeCampoEditar(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Habitacion::where($request->campo, '=', $request->valor)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->where('id_habitacion', '<>', $request->id_habitacion)->count();
            }
            
            return response()->json($val); 
        }
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = Auth::guard("usuario")->user()->id_local;
            $request->request->add(['id_local' => $id_local]);

            $res = Habitacion::create($request->all());
    
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

	public function editar($id)
    {
        return view('habitacion.editar', [
            'data' => Habitacion::where(['id_habitacion' => $id , 'estado' => 1])->first(), 
            'tipo_habitacion' => TipoHabitacion::all() 
        ]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Habitacion::find($request->id_habitacion);

            $data->numero             	= $request->numero; 
            $data->id_tipo_habitacion	= $request->id_tipo_habitacion;
            $data->precio 	            = $request->precio;
            $data->descripcion          = $request->descripcion;

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
    	if ($request->ajax())
        {
	      	$data = Habitacion::find($request->id_habitacion);
            $data->estado = 0;
            $res  = $data->save();
	    
	        return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
    	}
    }

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = Habitacion::with(['tipo_habitacion'])->find($request->id_habitacion);
            return response()->json($res);  
        }
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id = TipoHabitacion::where('nombre', 'LIKE', '%'.$request->search.'%')->first();

            $res =  Habitacion::with(['tipo_habitacion'])->where(function ($query) {
                        $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', '=', 1);
                    })->where(function ($query)  use ($request, $id) {
                        $query->where('numero', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('precio', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('descripcion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('situacion', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('id_tipo_habitacion', '=', $id ? $id->id_tipo_habitacion : '');
                    })->get();

            return view('habitacion.listar', ['data' => $res]); 
        }
    }


    public function estado($id)
    {
        $estado = ['DISPONIBLE', 'OCUPADO', 'MANTENIMIENTO'];

        $res = Habitacion::where('situacion', $estado[$id])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->orderBy('numero', 'asc')->get();

        return view('habitacion.listar', [ 'data' => $res]); 
    }

    public function activar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Habitacion::find($request->id_habitacion);
            $data->situacion = 'DISPONIBLE';
            $res  = $data->save();
        
            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }


    public function mantener(Request $request)
    {
        if ($request->ajax())
        {
            $data = Habitacion::find($request->id_habitacion);
            $data->situacion = 'MANTENIMIENTO';
            $res  = $data->save();
        
            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }
}
