<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;

use Auth;
use App\Models\Venta;
use App\Models\Reserva;
use App\Models\Local;
use App\Models\Huesped;
use App\Models\Habitacion;

class HomeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function index()
    {	
        $data = [
	    		'ventas' => Venta::where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'habitaciones' => Habitacion::where('estado', 1)->where('situacion', 'DISPONIBLE')->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'huespedes' => Huesped::where('estado', 1)->count(),
	    		'reservas' => Reserva::where('estado', 1)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    	];		
        return view('home', $data);
    }

    public function getVentas(Request $request)
    {	
    	if ($request->ajax())
	    { 
	    	$year = date("Y");
	    	$ventas = [
	    		'enero' => Venta::whereBetween('fecha_venta', [$year.'-01-01', $year.'-01-31'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'febrero' => Venta::whereBetween('fecha_venta', [$year.'-02-01', $year.'-02-28'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'marzo' => Venta::whereBetween('fecha_venta', [$year.'-03-01', $year.'-03-31'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'abril' => Venta::whereBetween('fecha_venta', [$year.'-04-01', $year.'-04-30'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'mayo' => Venta::whereBetween('fecha_venta', [$year.'-05-01', $year.'-05-31'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'junio' => Venta::whereBetween('fecha_venta', [$year.'-06-01', $year.'-06-30'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'julio' => Venta::whereBetween('fecha_venta', [$year.'-07-01', $year.'-07-31'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'agosto' => Venta::whereBetween('fecha_venta', [$year.'-08-01', $year.'-08-31'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'setiembre' => Venta::whereBetween('fecha_venta', [$year.'-09-01', $year.'-09-30'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'octubre' => Venta::whereBetween('fecha_venta', [$year.'-10-01', $year.'-10-31'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'noviembre' => Venta::whereBetween('fecha_venta', [$year.'-11-01', $year.'-11-30'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    		'diciembre' => Venta::whereBetween('fecha_venta', [$year.'-12-01', $year.'-12-31'])->where('estado', 1)->where('id_nota', null)->where('estado_envio','<>', null)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
	    	];

	        return response()->json($ventas); 
	    }    
    }
}