<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Habitacion;
use App\Models\TipoHabitacion;
use App\Models\Huesped;
use App\Models\Hospedar;
use App\Models\DetalleHospedar;
use App\Models\Cliente;
use App\Models\Reserva;

class HospedarController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

	public function listar()
    {
	 	$res = Habitacion::where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get();
        
        $data = [
            'disponibles' => Habitacion::where('situacion', 'DISPONIBLE')->where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get(),
            'ocupadas' => Habitacion::where('situacion', 'OCUPADO')->where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get(),
            'mantenimiento' => Habitacion::where('situacion', 'MANTENIMIENTO')->where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get(),
            'tipo_habitacion' => TipoHabitacion::get(),
        ];

        return view('hospedar.listar', $data); 
	}
    public function ingreso()
    {
        $res = Habitacion::where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get();
        
        $data = [
            'disponibles' => Habitacion::where('situacion', 'DISPONIBLE')->where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get(),
            'tipo_habitacion' => TipoHabitacion::get(),
        ];
        return view('hospedar.ingreso', $data); 
    }

    public function salida()
    {
        $res = Habitacion::where('estado', 1)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get();
        
        $data = [
            'ocupadas' => Hospedar::join('habitaciones', 'habitaciones.id_habitacion','=', 'hospedar.id_habitacion')->where('habitaciones.situacion', 'OCUPADO')->where('hospedar.observacion', 'ACTIVO')->where('hospedar.id_local', Auth::guard("usuario")->user()->id_local)->orderBy('habitaciones.numero', 'asc')->get(),
            //'ocupadas' => Hospedar::with('habitacion')->where('observacion', 'ACTIVO')->where('id_local', Auth::guard("usuario")->user()->id_local)->get(),
            'tipo_habitacion' => TipoHabitacion::get(),
        ];
        return view('hospedar.salida', $data); 
    }

    public function nuevo($id)
    {
        return view('hospedar.nuevo', [
            'data' => Habitacion::where('id_habitacion', $id)->where('situacion', 'DISPONIBLE')->where('estado', 1)->first(),
        ]); 
    }


	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = Auth::guard("usuario")->user()->id_local;
            $id_usuario = Auth::guard("usuario")->user()->id_usuario;
            $fecha_ingreso = date('Y-m-d H:i:s');

            $request->request->add(['id_local' => $id_local]);
            $request->request->add(['id_usuario' => $id_usuario]);
            $request->request->add(['fecha_ingreso' => $fecha_ingreso ]);
            $request->request->add(['observacion' => 'ACTIVO' ]);

            if (count(Habitacion::where('id_habitacion', $request->id_habitacion)->where('situacion', 'DISPONIBLE')->get()) == 1) { 
                $res = Hospedar::create($request->all());
            }
            else {
                $res = null;
            }

            if ($res) {
                $data = Habitacion::find($res->id_habitacion);
                $data->situacion = 'OCUPADO';
                $data->save();

                $detalle = [
                    'id_hospedar' => $res->id_hospedar,
                    'id_huesped' => $request->id_huesped,
                    'motivo' => $request->motivo,
                    'papeleta' => $request->papeleta
                ];

                $res1 = DetalleHospedar::create($detalle);
            }
    
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res);

        }
	}

    public function detalles($id)
    {
        return view('hospedar.detalles', [
            'data' => Hospedar::with(['local', 'usuario', 'habitacion'])->where(['id_hospedar' => $id, 'observacion' => 'ACTIVO'])->first(),
            'detalles' => DetalleHospedar::with(['huesped'])->where(['id_hospedar' => $id])->get(),
            'fecha_actual' => date('Y-m-d H:i:s')
        ]); 
    }


    public function desocupar(Request $request)
    {
        if ($request->ajax())
        {    
            $hos = Hospedar::where('id_hospedar', $request->id_hospedar)->first();

            $data = Hospedar::find($hos->id_hospedar);
            $data->observacion = 'TERMINADO';
            $data->fecha_salida = date('Y-m-d H:i:s');
            $res = $data->save();

            if ($res) {
                $data2 = Habitacion::find($hos->id_habitacion);
                $data2->situacion = 'DISPONIBLE';
                $data2->save();
            }

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']); 

        }
    }

    public function agregar($id)
    {
        return view('hospedar.agregar', [
            'data' => Hospedar::with('habitacion')->where('id_hospedar', $id)->where('observacion', 'ACTIVO')->where('estado', 1)->first(),
        ]); 
    }

    public function registrar_agregar(Request $request)
    {
        if ($request->ajax())
        {    
            $res = Hospedar::find($request->id_hospedar); 

            $detalle = [
                'id_hospedar' => $request->id_hospedar,
                'id_huesped' => $request->id_huesped,
                'motivo' => $request->motivo,
                 'papeleta' => $request->papeleta
            ];

            DetalleHospedar::create($detalle);

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 

        }
    }

    public function transferir($id)
    {
        $hos = Hospedar::with('habitacion')->where('id_hospedar', $id)->where('observacion', 'ACTIVO')->where('estado', 1)->first();
        $data = [
            'disponibles' => Habitacion::where('situacion', 'DISPONIBLE')->where('estado', 1)->where('id_habitacion','<>', $hos->id_habitacion)->where('id_local', '=', Auth::guard("usuario")->user()->id_local)->orderBy('numero', 'asc')->get(),
            'data' => $hos,
        ];

        return view('hospedar.transferir', $data); 
    }

    public function registrar_transferir(Request $request)
    {
        if ($request->ajax())
        {    
            //Primero desocupamos la habitacion
            $origen = Hospedar::where('id_hospedar', $request->id_hospedar_origen)->first();

            $data1 = Hospedar::find($origen->id_hospedar);
            $data1->observacion = 'TERMINADO';
            $data1->fecha_salida = date('Y-m-d H:i:s');
            $data1->save();

            $data2 = Habitacion::find($origen->id_habitacion);
            $data2->situacion = 'DISPONIBLE';
            $data2->save();

            //Segundo registramos huespedes en la nueva habitacion

            $id_local = Auth::guard("usuario")->user()->id_local;
            $id_usuario = Auth::guard("usuario")->user()->id_usuario;

            $request->request->add(['id_local' => $id_local]);
            $request->request->add(['id_usuario' => $id_usuario]);
            $request->request->add(['observacion' => 'ACTIVO' ]);
            $request->request->add(['fecha_ingreso' => $origen->fecha_ingreso ]);
            $request->request->add(['id_venta' => $origen->id_venta]);

            $res = Hospedar::create($request->all());

            if ($res) {
                $data = Habitacion::find($res->id_habitacion);
                $data->situacion = 'OCUPADO';
                $data->save();

                $huespedes = DetalleHospedar::where('id_hospedar', $origen->id_hospedar)->get(); 
                foreach ($huespedes as $huesped) {
                    $detalle = [
                        'id_hospedar' => $res->id_hospedar,
                        'id_huesped' => $huesped->id_huesped,
                        'motivo' => $huesped->motivo,
                        'papeleta' => $huesped->papeleta
                    ];
                   $res1 = DetalleHospedar::create($detalle);
                }
            }

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 

        }
    }


    public function registrar_reserva(Request $request)
    {
        if ($request->ajax())
        {    
            $buscar = Huesped::where('dni', $request->dni)->first();

            if ($buscar) {
                $request->request->add(['id_huesped' => $buscar->id_huesped]);
            }
            else{
                $datos_huesped = [
                    'nombre' => $request->nombre,
                    'dni' => $request->dni,
                    'genero' => $request->genero,
                    'telefono' => $request->telefono,
                    'email' => $request->email,
                    'pais' => $request->pais,
                    'ciudad' => $request->ciudad,
                    'razon_social' => $request->razon_social,
                    'ruc' => $request->ruc,
                    'direccion_empresa' => $request->direccion_empresa
                ];

                $res1 = Huesped::create($datos_huesped); 

                if ($res1) {

                    if (strlen($request->dni) == 8 && is_numeric($request->dni))
                    {
                        $cli = Cliente::where('numero_documento', $request->dni)->get();    
                        if (count($cli) == 0) {
                            $detalle_cliente = [
                                'nombre'            =>  $request->nombre,
                                'id_tipo_documento' =>  2,
                                'numero_documento'  =>  $request->dni,
                                'direccion'         =>  $request->direccion_empresa,
                                'email'             =>  $request->email,
                                'telefono'          =>  $request->telefono,
                            ];
                            Cliente::create($detalle_cliente);
                        }
                    }
                    if (strlen($request->ruc) == 11 && is_numeric($request->ruc))
                    {
                        $emp = Cliente::where('numero_documento', $request->ruc)->get();    
                        if (count($emp) == 0) {
                            $detalle_empresa = [
                                'nombre'            =>  $request->razon_social,
                                'id_tipo_documento' =>  1,
                                'numero_documento'  =>  $request->ruc,
                                'direccion'         =>  $request->direccion_empresa,
                                'email'             =>  $request->email,
                                'telefono'          =>  $request->telefono,
                            ];
                            Cliente::create($detalle_empresa);
                        }
                    }     
                }
                $request->request->add(['id_huesped' => $res1->id_huesped]);
            }

            //registramos huespedes en la nueva habitacion
            $fecha_ingreso = date('Y-m-d H:i:s');
            $request->request->add(['id_local' => Auth::guard("usuario")->user()->id_local]);
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]);
            $request->request->add(['observacion' => 'ACTIVO' ]);
            $request->request->add(['fecha_ingreso' => $fecha_ingreso ]);

            $res = Hospedar::create($request->all());

            if ($res) {
                $data = Habitacion::find($res->id_habitacion);
                $data->situacion = 'OCUPADO';
                $data->save();

                $detalle = [
                    'id_hospedar' => $res->id_hospedar,
                    'id_huesped' => $request->id_huesped,
                    'motivo' => $request->motivo
                ];
                DetalleHospedar::create($detalle);

                $rev = Reserva::find($request->id_reserva);
                $rev->observacion = 'REGISTRADO';
                $rev->save();
            }
    
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 

        }
    }



}
