<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Huesped;
use App\Models\Cliente;

class HuespedController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function nuevo()
    {
	 	return view('huesped.nuevo'); 
	}

	public function listar()
    {
	 	$res = Huesped::where('estado', 1)->orderBy('nombre', 'asc')->paginate(10);
        return view('huesped.listar', [ 'data' => $res]); 
	}

    public function existeCampo(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Huesped::where($request->campo, '=', $request->valor)->count();
            }
            
            return response()->json($val); 
        }
    }

    public function existeCampoEditar(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Huesped::where($request->campo, '=', $request->valor)->where('id_huesped', '<>', $request->id_huesped)->count();
            }
            
            return response()->json($val); 
        }
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    

            $origDate = str_replace('/', '-', $request->fecha_nacimiento);
            $newDate = date('Y-m-d', strtotime($origDate));
            $request->merge(['fecha_nacimiento' => $newDate]);

            $res = Huesped::create($request->all());

            if ($res) {

                if (strlen($res->dni) == 8 && is_numeric($res->dni))
                {
                    $cli = Cliente::where('numero_documento', $res->dni)->get();    
                    if (count($cli) == 0) {
                        $detalle_cliente = [
                            'nombre'            =>  $request->nombre,
                            'id_tipo_documento' =>  2,
                            'numero_documento'  =>  $request->dni,
                            'direccion'         =>  $request->direccion_empresa,
                            'email'             =>  $request->email,
                            'telefono'          =>  $request->telefono,
                        ];
                        Cliente::create($detalle_cliente);
                    }
                }
                if (strlen($res->ruc) == 11 && is_numeric($res->ruc))
                {
                    $emp = Cliente::where('numero_documento', $res->ruc)->get();    
                    if (count($emp) == 0) {
                        $detalle_empresa = [
                            'nombre'            =>  $request->razon_social,
                            'id_tipo_documento' =>  1,
                            'numero_documento'  =>  $request->ruc,
                            'direccion'         =>  $request->direccion_empresa,
                            'email'             =>  $request->email,
                            'telefono'          =>  $request->telefono,
                        ];
                        Cliente::create($detalle_empresa);
                    }
                }     
            }

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

	public function editar($id)
    {
        return view('huesped.editar', [
            'data' => Huesped::where(['id_huesped' => $id , 'estado' => 1])->first(),
        ]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Huesped::find($request->id_huesped);

            $data->nombre             	= $request->nombre; 
            $data->dni	                = $request->dni;
            $data->ocupacion 	        = $request->ocupacion;
            $data->genero               = $request->genero;
            $data->fecha_nacimiento     = $request->fecha_nacimiento; 
            $data->email                = $request->email;
            $data->telefono             = $request->telefono;
            $data->pais                 = $request->pais;
            $data->ciudad               = $request->ciudad; 
            $data->razon_social         = $request->razon_social;
            $data->ruc                  = $request->ruc;
            $data->direccion_empresa    = $request->direccion_empresa;

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
    	if ($request->ajax())
        {
	      	$data = Huesped::find($request->id_huesped);
            $data->estado = 0;
            $res  = $data->save();
	    
	        return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
    	}
    }

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = Huesped::find($request->id_huesped);
            return response()->json($res);  
        }
    }

    public function getByDni(Request $request)
    {
        if ($request->ajax())
        {
            $res = Huesped::where('dni', $request->dni)->where('estado', 1)->first();
            return response()->json($res);  
        }
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $res =  Huesped::where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('dni', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('ocupacion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('fecha_nacimiento', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('genero', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('telefono', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('pais', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('ciudad', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('razon_social', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('ruc', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('direccion_empresa', 'LIKE', '%'.$request->search.'%');
                    })->paginate(10);

            $res->appends(['search' => $request->search]); 
            return view('huesped.listar', ['data' => $res]); 
        }
    }

}
