<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Local;
use App\Models\Nota;


class LocalController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function nuevo()
    {
        return view('local.nuevo'); 
	}

	public function listar()
	{
		$res = Local::where('estado', 1)->get();
        return view('local.listar', [ 'data' => $res]); 
	}

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $request->request->add(['serie_factura' => 'F00'.(Local::where('estado', 1)->count()+1)]);
            $request->request->add(['serie_boleta' => 'B00'.(Local::where('estado', 1)->count()+1)]);

            $res = Local::create($request->all());

            DB::table('ventas')->insert([
                ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 1,'serie_comprobante' => $res->serie_factura,'numero_comprobante' => '0'],
                ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 2,'serie_comprobante' => $res->serie_boleta,'numero_comprobante' => '0'
                ],
            ]);

            //Nota credito y debito
            DB::table('notas')->insert([
                ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 3,'serie_nota' => $res->serie_factura,'numero_nota' => '0'],
                ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 3,'serie_nota' => $res->serie_boleta,'numero_nota' => '0'],
                ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 4,'serie_nota' => $res->serie_factura,'numero_nota' => '0'],
                ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 4,'serie_nota' => $res->serie_boleta,'numero_nota' => '0'],
            ]);

        

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']); 
        }
	}

	public function editar($id)
    {
        return view('local.editar', [
            'data' => Local::where(['id_local' => $id , 'estado' => 1])->first(), 
        ]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Local::find($request->id_local);

            $data->nombre             = $request->nombre; 
            $data->direccion          = $request->direccion;
            $data->telefono           = $request->telefono;

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
    	if ($request->ajax())
        {
	      	$data = Local::find($request->id_local);
            $data->estado = 0;
            $res  = $data->save();
	    
	        return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
    	}
    }

    public function getAll(Request $request)
    {
        if ($request->ajax())
        {
            $res = Local::where('estado', 1)->get();
            return response()->json($res);  
        }
    }

}
