<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Nota;
use App\Models\Local;
use App\Models\Venta;
use App\Models\Empresa;
use App\Models\TipoComprobante;
use App\Models\DetalleVenta;
use App\Models\ProductoLocal;
use App\Http\Controllers\XmlController;

class NotaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function listar_credito()
    {
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('id_tipo_comprobante', 3)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_tipo_comprobante', 3)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('nota.listar_credito', [ 'data' => $res]); 
    }

    public function estado_credito($id)
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'PENDIENTE', 'REGISTRADO'];
        
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_tipo_comprobante', 3)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_tipo_comprobante', 3)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('nota.listar_credito', [ 'data' => $res]); 
    }

    public function listar_debito()
    {
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('id_tipo_comprobante', 4)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_tipo_comprobante', 4)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('nota.listar_debito', [ 'data' => $res]); 
    }

    public function estado_debito($id)
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'REGISTRADO'];

        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_tipo_comprobante', 4)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Nota::with(['local', 'venta', 'tipo_comprobante'])->where('estado_envio', $estado[$id])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_tipo_comprobante', 4)->where('estado_envio', '<>',null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('nota.listar_debito', [ 'data' => $res]); 
    }

	public function credito($id)
    {
        return view('nota.nuevo_credito', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where('id_nota' , null)->where(['id_venta' => $id])->first(),
        ]); 
    }

    public function registrar_credito(Request $request)
    {
        if ($request->ajax())
        {    
            $prev = Venta::where('id_nota' , null)->where(['id_venta' => $request->id_venta])->first();

            if ($prev) {

                $id_local = Auth::guard("usuario")->user()->id_local;
                $correl = $this->getCorrelativo($request->id_tipo_comprobante, $id_local, $request->id_venta);

                $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
                $request->request->add(['id_local' => $id_local]);
                $request->request->add(['serie_nota' => $correl['serie']]);
                $request->request->add(['numero_nota' => $correl['numero']]);
                $request->request->add(['nombre_nota' => $correl['nombre']]);

                $request->request->add(['estado_envio' => 'REGISTRADO']);
                $request->request->add(['mensaje_envio' => 'La nota fue emitida correctamente']);

                $res = Nota::create($request->all());

                if ($res) {

                    $data = Venta::find($res->id_venta);
                    $data->id_nota = $res->id_nota; 
                    $data->save();

                    $xml = new XmlController();
                    $xml->crearNotaCredito($res->id_nota); 
                }
                
                $res ? $res['message'] = 'success' : $res['message'] = 'error';
            }    
            else {
                $res['message'] = 'error';
            }

            return response()->json($res); 
        }
    }

    public function registrar_debito(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = Auth::guard("usuario")->user()->id_local;
            $correl = $this->getCorrelativo($request->id_tipo_comprobante, $id_local, $request->id_venta);

            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $request->request->add(['id_local' => $id_local]);
            $request->request->add(['serie_nota' => $correl['serie']]);
            $request->request->add(['numero_nota' => $correl['numero']]);
            $request->request->add(['nombre_nota' => $correl['nombre']]);

            $request->request->add(['estado_envio' => 'REGISTRADO']);
            $request->request->add(['mensaje_envio' => 'La nota fue emitida correctamente']);

            $res = Nota::create($request->all());

            if ($res) {

                //Modificar total venta
                $data = Venta::find($res->id_venta);
                $data->total_venta = $request->monto; 
                $data->save();
                
                $xml = new XmlController();
                $xml->crearNotaDebito($res->id_nota); 
            }
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }

    public function getCorrelativo($tipo, $id_local, $id_venta)
    {
        $venta = Venta::where('id_venta', $id_venta)->first();
        $serie = $venta->serie_comprobante;
        $num = Nota::where(['id_tipo_comprobante' => $tipo, 'id_local' => $id_local, 'serie_nota' => $serie, 'estado' => 1])->max('numero_nota');

        return ['numero' => $num + 1, 'serie' => $serie, 'nombre' => $serie.'-'.($num+1)];
    }

    public function detalles($id)
    {
        $data = Nota::with(['local', 'venta', 'usuario', 'tipo_comprobante'])->where(['id_nota' => $id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        return view('nota.detalles', [
            'data' => $data,
            'empresa' => $empresa,
            'detalle_venta' => DetalleVenta::where(['id_venta' => $data->id_venta , 'estado' => 1])->get(),
        ]); 
    }


    public function debito($id)
    {
        return view('nota.nuevo_debito', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where(['id_venta' => $id])->first(),
        ]); 
    }

}
