<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Venta;
use App\Models\DetalleVenta;
use App\Models\Proforma;
use App\Models\DetalleProforma;
use App\Models\Local;
use App\Models\Cliente;
use App\Models\Usuario;
use App\Models\TipoComprobante;
use App\Models\TipoDocumento;
use App\Models\Empresa;
use App\Http\Controllers\XmlController;

class ProformaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function listar()
    {
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Proforma::with(['local', 'usuario'])->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }
        else{
            $res = Proforma::with(['local', 'usuario'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
        }

        return view('proforma.listar', [ 'data' => $res]); 
    }

    public function nuevo()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
            'clientes' => Cliente::where('estado', 1)->orderBy('nombre', 'ASC')->limit(20)->get(), 
            'empresa' => Empresa::where('id_empresa', 1)->where('estado', 1)->first(), 

        ];
        return view('proforma.nuevo', $data); 
    }

    public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = Auth::guard("usuario")->user()->id_local;
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $request->request->add(['id_local' => $id_local]);
            $request->request->add(['total' => $request->total_venta]);
            $res = Proforma::create($request->all());
            
            if ($res) 
            {
                for( $i = 0; $i < count($request->descripcion); $i++)
                {
                    $detalle= [
                        'id_proforma' => $res->id_proforma, 
                        'descripcion' => $request->descripcion[$i], 
                        'cantidad' => $request->cantidad[$i], 
                        'precio' => $request->precio_venta[$i], 
                        'descuento' => $request->descuento[$i], 
                        'subtotal' => $request->subtotal[$i], 
                    ];

                    $res1 = DetalleProforma::create($detalle);

                }  

            }
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 

        }
    }

    public function detalles($id)
    {
        return view('proforma.detalles', [
            'data' => Proforma::with(['local', 'usuario'])->where(['id_proforma' => $id])->first(),
            'detalle_proforma' => DetalleProforma::where(['id_proforma' => $id])->get(),
        ]); 
    }

     public function buscar(Request $request)
    {
        if ($request)
        {
            $id1 = Local::where('nombre', 'LIKE', '%'.$request->search.'%')->first();

            if (Auth::guard("usuario")->user()->id_rol == 1) 
            {
                $res =  Proforma::with(['local'])->where(function ($query) {
                        $query->where('estado', 1);
                    })->where(function ($query)  use ($request, $id1) {
                        $query->where('total', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('numero_documento', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('direccion', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('fecha_emision', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('id_local', '=', $id1 ? $id1->id_local : '');
                    })->paginate(10);
            }
            else
            {
                $res =  Proforma::with(['local'])->where(function ($query) {
                        $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1);
                    })->where(function ($query)  use ($request, $id1) {
                        $query->where('total', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('numero_documento', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('direccion', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('fecha_emision', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('id_local', '=', $id1 ? $id1->id_local : '');
                    })->paginate(10);
            }
            $res->appends(['search' => $request->search]); 
            return view('proforma.listar', [ 'data' => $res]); 

        }
    }

    public function getProductosById(Request $request)
    {
        if ($request)
        {
            $prod =  DetalleProforma::with(['producto'])->where(['id_proforma' => $request->id_proforma])->get();

            if ($prod)
            { 
                foreach ($prod as $data) {
                    $res[] = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $data->id_producto)->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->first();
                }
            }
            return response()->json($res); 
        }
    }



}
