<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Local;
use App\Models\Proveedor;
use App\Models\Usuario;
use App\Models\Venta;

class ReporteController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function comprobantes()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.comprobantes', $data); 
    }

    public function ventas()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.ventas', $data); 
    }

    public function compras()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
            'proveedores' => Proveedor::where('estado', 1)->get(), 
        ];

        return view('reporte.compras', $data); 
    }

    public function usuarios()
    {
        $data = [
            'usuarios' => Usuario::where('estado', 1)->get(), 
            'locales' => Local::where('estado', 1)->get(), 
            'consulta' => DB::table('ventas')->join('usuarios', 'ventas.id_usuario', '=', 'usuarios.id_usuario')
                     ->select('ventas.id_usuario', 'nombres', 'apellidos', 'dni', 'fecha_venta', DB::raw('count(*) as ventas, sum(total_venta) as monto'))
                     ->where('ventas.estado', 1)
                     ->where('ventas.fecha_venta', date('Y-m-d'))
                     ->groupBy('ventas.id_usuario')
                     ->get(),
        ];

        return view('reporte.usuarios', $data); 
    }

    public function detalles($id)
    {
        return view('reporte.detalles', [
            'usuario' => Usuario::where(['id_usuario' => $id])->first(),
            'data' => Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_usuario' => $id, 'fecha_venta' => date('Y-m-d')])->get(),
        ]); 
    }

    public function productos_vendidos()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.productos_vendidos', $data); 
    }

    public function productos_comprados()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.productos_comprados', $data); 
    }

    public function stock()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.stock', $data); 
    }

    public function egresos()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.egresos', $data); 
    }

    public function guia()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.guia', $data); 
    }

    public function alojamiento()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.alojamiento', $data); 
    }

    public function actuales()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.actuales', $data); 
    }

    public function proformas()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.proformas', $data); 
    }


}