<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Reserva;
use App\Models\Habitacion;
use App\Models\Local;

class ReservaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function nuevo()
    {
	 	$res = Habitacion::with('tipo_habitacion')->where('estado', 1)->orderBy('numero', 'asc')->get();
        return view('reserva.nuevo', [ 'habitaciones' => $res]); 
	}

	public function listar()
    {
	 	$res = Reserva::with('habitacion')->where('estado', 1)->where('observacion', 'PENDIENTE')->paginate(10);
        return view('reserva.listar', [ 'data' => $res]); 
	}

    public function cancelados()
    {
        $res = Reserva::with('habitacion')->where('estado', 1)->where('observacion', 'CANCELADO')->paginate(10);
        return view('reserva.cancelados', [ 'data' => $res]); 
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $request->request->add(['id_local' => Auth::guard("usuario")->user()->id_local]);
            $request->request->add(['observacion' => 'PENDIENTE']); // PENDIENTE | CANCELADO | REGISTRADO

            $res = Reserva::create($request->all());

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

    public function detalles($id)
    {
        return view('reserva.detalles', [
            'data' => Reserva::with(['habitacion', 'usuario'])->where(['id_reserva' => $id])->first(),
        ]); 
    }

    public function cancelar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Reserva::find($request->id_reserva);
            $data->observacion  = 'CANCELADO'; 
            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $res =  Reserva::where(function ($query) {
                        $query->where('estado', '=', 1)->where('observacion', 'PENDIENTE');
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('dni', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('telefono', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('medio', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('fecha_llegada', 'LIKE',  '%'.$request->search.'%');
                    })->paginate(10);

            $res->appends(['search' => $request->search]); 
            return view('reserva.listar', ['data' => $res]); 
        }
    }

    public function ocupar($id)
    {
        return view('reserva.ocupar', [
            'data' => Reserva::with(['habitacion', 'usuario'])->where(['id_reserva' => $id])->first(),
            'disponibles' => Habitacion::with('tipo_habitacion')->where('situacion', 'DISPONIBLE')->where('estado', 1)->orderBy('numero', 'asc')->get()
        ]); 
    }

    public function alertas(Request $request)
    {
        if ($request->ajax())
        {
            $reserva = Reserva::with(['habitacion'])->where(['observacion' => 'PENDIENTE', 'estado' => 1])->get();
            $datos = null;

            foreach ($reserva as $data) {

                $datetime1 = date_create(date('Y-m-d'));
                $datetime2 = date_create($data->fecha_llegada);
                $interval = date_diff($datetime1, $datetime2);
                if ($interval->days < 2 &&  $datetime1 < $datetime2) {
                    $datos[] = $data;
                }

                if ($datetime1 > $datetime2) {
                    $data2 = Reserva::find($data->id_reserva);
                    $data2->observacion = "CANCELADO";
                    $data2->save();
                }
            }
            return response()->json($datos);  
        }
    }
}
