<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Resumen;
use App\Models\DetalleResumen;
use App\Models\Venta;
use App\Models\Empresa;


class ResumenController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    


	public function listar()
    {
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Resumen::with('tipo_comprobante')->where('estado', 1)->orderBy('fecha_referencia', 'desc')->paginate(10);
        }
        else{
            $res = Resumen::with('tipo_comprobante')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->orderBy('fecha_referencia', 'desc')->paginate(10);
        }

        return view('resumen.listar', [ 'data' => $res]); 
    }


    public function detalles($id)
    {
        return view('resumen.detalles', [
            'data' => Resumen::where(['id_resumen' => $id , 'estado' => 1])->first(),
            'empresa' => Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first(),
            'detalle_resumen' => DetalleResumen::with(['venta'])->where(['id_resumen' => $id , 'estado' => 1])->get(),
        ]); 
    }

    public function estado($id)
    {
        //$estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'REGISTRADO'];
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'PENDIENTE'];
        
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Resumen::where('estado_envio', $estado[$id])->where('estado', 1)->orderBy('fecha_referencia', 'desc')->paginate(10);
        }
        else{
            $res = Resumen::where('estado_envio', $estado[$id])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->orderBy('fecha_referencia', 'desc')->paginate(10);
        }

        return view('resumen.listar', [ 'data' => $res]); 

    }

}
