<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Venta;
use App\Models\Local;
use App\Models\Cliente;
use App\Models\Producto;
use App\Models\Usuario;
use App\Models\ProductoLocal;
use App\Models\DetalleVenta;
use App\Models\TipoComprobante;
use App\Models\TipoDocumento;
use App\Models\TipoPresentacion;
use App\Models\UnidadMedida;
use App\Models\Proforma;
use App\Models\DetalleProforma;
use App\Http\Controllers\XmlController;
use App\Models\Hospedar;
use App\Models\DetalleHospedar;
use App\Models\Empresa;

class VentaController extends Controller
{
	public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function listar()
    {
	 	if (Auth::guard("usuario")->user()->id_rol == 1) {
	 		$res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_nota', null)->where('id_cliente', '<>', null)->where('contingencia', 0)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
	 	}
	 	else{
	 		$res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_nota', null)->where('id_cliente', '<>', null)->where('contingencia', 0)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(10);
	 	}

        return view('venta.listar', [ 'data' => $res]); 
	}

    public function listar_anulados()
    {
        if (Auth::guard("usuario")->user()->id_rol == 1) {
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante', 'nota'])->where('id_nota', '<>',null)->where('id_cliente', '<>', null)->where('estado', 1)->where('contingencia', 0)->orderBy('updated_at', 'desc')->paginate(10);
        }
        else{
            $res = Venta::with(['local', 'cliente', 'tipo_comprobante', 'nota'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_nota', '<>',null)->where('id_cliente', '<>', null)->where('contingencia', 0)->where('estado', 1)->orderBy('updated_at', 'desc')->paginate(10);
        }

        return view('venta.listar_anulados', [ 'data' => $res]); 
    }

    public function nuevo()
    {
        $correl = $this->getCorrel(1, Auth::guard("usuario")->user()->id_local);

        $data = [
            'locales' => Local::where('estado', 1)->get(), 
            'clientes' => Cliente::where('estado', 1)->limit(50)->get(), 
            'tipo_documento' => TipoDocumento::all(), 
            'tipo_comprobante' => TipoComprobante::where('grupo', 1)->get(), 
            'empresa' => Empresa::where('id_empresa', 1)->where('estado', 1)->first(), 
            'serie' => $correl['serie'],
            'numero' => $correl['numero'],
        ];
        return view('venta.nuevo', $data); 
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            
            if(!is_null($request->numero_documento)){

                $buscar = Cliente::where('numero_documento', $request->numero_documento)->first();

                if ($buscar) {
                    $request->request->add(['id_cliente' => $buscar->id_cliente]);

                    if ($buscar->id_cliente !=1) {
                            $cli = Cliente::find($buscar->id_cliente);
                            $cli->nombre = $request->nombre;
                            $cli->direccion = $request->direccion;
                            $cli->save(); 
                    }
                }
                else{
                    $data = [
                        'nombre' => $request->nombre,
                        'numero_documento' => $request->numero_documento,
                        'id_tipo_documento' => $request->id_tipo_documento,
                        'direccion' => $request->direccion
                    ];
                    $cli = Cliente::create($data); 
                    $request->request->add(['id_cliente' => $cli->id_cliente]);
                }
                
            } else {
                $request->request->add(['id_cliente' => 1]);
            }

            $id_local = Auth::guard("usuario")->user()->id_local;
            $correl = $this->getCorrel($request->id_tipo_comprobante, $id_local);
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $request->request->add(['id_local' => $id_local]);
            $request->request->add(['serie_comprobante' => $correl['serie']]);
            $request->request->add(['numero_comprobante' => $correl['numero']]);
            $request->request->add(['nombre_comprobante' => $correl['nombre']]);
            $request->request->add(['fecha_venta' => date('Y-m-d')]);
            $request->request->add(['estado_envio' => 'REGISTRADO']);
            $request->request->add(['mensaje_envio' => 'La venta fue registrada correctamente']);

 			$res = Venta::create($request->all());
            
            if ($res) 
            {
	        	for( $i = 0; $i < count($request->descripcion); $i++)
	            {
	                $detalle_venta= [
	                	'id_venta' => $res->id_venta, 
	                	'descripcion' => $request->descripcion[$i], 
			        	'cantidad' => $request->cantidad[$i], 
			        	'precio_venta' => $request->precio_venta[$i], 
			        	'impuesto' => $request->impuesto[$i], 
			        	'precio_venta_neto' => number_format($request->subtotal[$i]-$request->impuesto[$i], 2, '.', ''), 
			        	'descuento' => $request->descuento[$i], 
			        	'precio_venta_total' => $request->subtotal[$i], 
	                ];

	                $res1 = DetalleVenta::create($detalle_venta);
		        }

                if ($request->id_hospedar) {
                    $hos = Hospedar::find($request->id_hospedar);
                    $hos->id_venta = $res->id_venta;
                    $hos->save();
                }

                //Creamos documentos XML
                $xml = new XmlController();
                $xml->crearComprobante($res->id_venta);    
	        }
	        
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

    public function getCorrel($tipo, $id_local)
    {
        $num = Venta::where(['id_tipo_comprobante' => $tipo, 'id_local' => $id_local, 'estado' => 1])->max('numero_comprobante');
        if ($tipo == 1) {
            $res = Local::where(['id_local' => $id_local , 'estado' => 1])->first();
            $serie = $res->serie_factura;
        }
        if ($tipo == 2) {
            $res = Local::where(['id_local' => $id_local , 'estado' => 1])->first();
            $serie = $res->serie_boleta;
        }

        return ['numero' => $num + 1, 'serie' => $serie, 'nombre' => $serie.'-'.($num+1)];
    }

    public function getCorrelativo(Request $request)
    {
        if ($request->ajax())
        {
            $num = Venta::where(['id_tipo_comprobante' => $request->id_tipo_comprobante, 'id_local' => $request->id_local, 'estado' => 1])->max('numero_comprobante');

            if ($request->id_tipo_comprobante == 1) {
                $res = Local::where(['id_local' => $request->id_local , 'estado' => 1])->first();
                $serie = $res->serie_factura;
            }
            if ($request->id_tipo_comprobante == 2) {
                $res = Local::where(['id_local' => $request->id_local , 'estado' => 1])->first();
                $serie = $res->serie_boleta;
            }

            return response()->json(['numero' => $num + 1, 'serie' => $serie]); 
        }    
    }

	public function detalles($id)
    {
        return view('venta.detalles', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where(['id_venta' => $id])->first(),
            'detalle_venta' => DetalleVenta::where(['id_venta' => $id])->get(),
        ]); 
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id1 = Cliente::where('nombre', 'LIKE', '%'.$request->search.'%')->orWhere('numero_documento', $request->search)->first();
            $id2 = Local::where('nombre', 'LIKE', '%'.$request->search.'%')->first();
            $id3 = TipoComprobante::where('nombre', 'LIKE', '%'.$request->search.'%')->first();

        	if (Auth::guard("usuario")->user()->id_rol == 1) 
        	{
		 		$res =  Venta::with(['local', 'cliente'])->where(function ($query) {
                        $query->where('estado', 1)->where('id_cliente','<>', null);
                    })->where(function ($query)  use ($request, $id1 ,$id2 ,$id3) {
                        $query->where('total_venta', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('tipo_pago', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('fecha_venta', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('serie_comprobante', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('numero_comprobante', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('nombre_comprobante', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('estado_envio', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('id_cliente', '=', $id1 ? $id1->id_cliente : '')
                              ->orWhere('id_local', '=', $id2 ? $id2->id_local : '')
                              ->orWhere('id_tipo_comprobante', '=', $id3 ? $id3->id_tipo_comprobante : '');
                    })->paginate(10);
		 	}
		 	else
		 	{
		 		$res =  Venta::with(['local', 'cliente'])->where(function ($query) {
                        $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('id_cliente','<>', null);
                    })->where(function ($query)  use ($request, $id1 ,$id2 ,$id3) {
                        $query->where('total_venta', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('tipo_pago', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('fecha_venta', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('serie_comprobante', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('numero_comprobante', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('nombre_comprobante', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('estado_envio', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('id_cliente', '=', $id1 ? $id1->id_cliente : '')
                              ->orWhere('id_local', '=', $id2 ? $id2->id_local : '')
                              ->orWhere('id_tipo_comprobante', '=', $id3 ? $id3->id_tipo_comprobante : '');
                    })->paginate(10);
		 	}
            
            $res->appends(['search' => $request->search]); 
	        return view('venta.listar', [ 'data' => $res]); 

        }
    }

    public function listar_deuda()
    {
        $res = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_nota', null)->where('fecha_pago', '<>', null)->where('tipo_pago', 'CREDITO')->orderBy('created_at', 'desc')->paginate(10);

        return view('venta.listar_deuda', [ 'data' => $res]); 
    }

    public function detalles_deuda($id)
    {
        return view('venta.detalles_deuda', [
            'data' => Venta::with(['local', 'cliente', 'usuario', 'tipo_comprobante'])->where(['id_venta' => $id])->first(),
            'detalle_venta' => DetalleVenta::where(['id_venta' => $id])->get(),
        ]); 
    }

    public function anular_deuda(Request $request)
    {
        if ($request->ajax())
        {
            $data = Venta::find($request->id_venta);
            $data->fecha_pago = null; 
            $data->tipo_pago = 'EFECTIVO'; 
            //$data->id_usuario = Auth::guard("usuario")->user()->id_usuario;
            $data->save();

            return response()->json($data ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function proforma_venta($id)
    {
        $correl = $this->getCorrel(1, Auth::guard("usuario")->user()->id_local);
        $data = [
            'proforma' => Proforma::with(['local', 'usuario'])->where(['id_proforma' => $id])->first(),
            'detalle_proforma' => DetalleProforma::where(['id_proforma' => $id])->get(),
            'locales' => Local::where('estado', 1)->get(), 
            'clientes' => Cliente::where('estado', 1)->get(), 
            'empresa' => Empresa::where('id_empresa', 1)->where('estado', 1)->first(), 
            'tipo_documento' => TipoDocumento::all(), 
            'tipo_comprobante' => TipoComprobante::where('grupo', 1)->get(), 

            'serie' => $correl['serie'],
            'numero' => $correl['numero']
        ];
        return view('proforma.venta', $data); 
    }

    public function hospedar_venta($id)
    {
        $correl = $this->getCorrel(1, Auth::guard("usuario")->user()->id_local);
        $detalle = DetalleHospedar::with('huesped')->where('id_hospedar', $id)->where('estado', 1)->orderBy('created_at', 'ASC')->first();

        $data = [
            'hospedar' => Hospedar::with('habitacion')->where('id_hospedar', $id)->where('observacion', 'ACTIVO')->where('estado', 1)->first(),
            'detalles' => $detalle,
            'natural' => Cliente::where('numero_documento', $detalle->huesped->dni)->where('id_tipo_documento', 2)->orderBy('created_at', 'ASC')->first(),
            'juridico' => Cliente::where('numero_documento', $detalle->huesped->ruc)->where('id_tipo_documento', 1)->orderBy('created_at', 'ASC')->first(),
            'locales' => Local::where('estado', 1)->get(), 
            'clientes' => Cliente::where('estado', 1)->limit(50)->get(), 
            'tipo_documento' => TipoDocumento::all(), 
            'tipo_comprobante' => TipoComprobante::where('grupo', 1)->get(), 
            'empresa' => Empresa::where('id_empresa', 1)->where('estado', 1)->first(), 
            'serie' => $correl['serie'],
            'numero' => $correl['numero'],
            'fecha_actual' => date('Y-m-d H:i:s'),
        ];

        return view('hospedar.venta', $data); 
    }




    
}
