<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\Venta;
use App\Models\DetalleVenta;
use App\Models\Resumen;
use App\Models\DetalleResumen;
use App\Models\Empresa;
use App\Models\Local;
use App\Models\Nota;


class XmlController extends Controller
{
    public function crearLlaves(){
        obtenerArchivosPEM();
    }

    public function crearComprobante($id){

        $venta = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_venta' => $id , 'estado' => 1])->first();
        $detalles = DetalleVenta::where(['id_venta' => $id , 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
            
        $array['comprobante']['total'] = $venta->total_venta;
        $array['comprobante']['nombre_cliente'] = $venta->cliente->nombre;
        $array['comprobante']['num_doc_cliente'] = $venta->cliente->numero_documento;
        $array['comprobante']['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo; // 01 FACTURA | 03 BOLETA
        $array['comprobante']['fecha'] = $venta->fecha_venta;
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['comprobante']['hora'] = date("H:i:s", strtotime($venta->created_at));

        $array['comprobante']['fecha_pago'] = $venta->fecha_pago;
        
        // Inicio Tipo Pago
        if ($venta->tipo_pago == "EFECTIVO" || $venta->tipo_pago == "TARJETA") { $array['comprobante']['tipo_pago'] = 'Contado'; }
        else { $array['comprobante']['tipo_pago'] = 'Credito'; }
        // Fin Tipo Pago

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        $impuesto = 0;
        $subtotal = 0;
        $i = 0;
        foreach ($detalles as $row) {
            
            $precio_unitario = $row->precio_venta_total/$row->cantidad;
            $array['detalle'][$i]['id_producto'] = $i+1;
            $array['detalle'][$i]['cantidad'] = $row->cantidad;
            $array['detalle'][$i]['descripcion'] = $row->descripcion;
            $array['detalle'][$i]['precio_unitario'] = number_format($precio_unitario, 2, ".", "");
            $array['detalle'][$i]['precio_unitario_neto'] = number_format($precio_unitario/(1+($empresa->valor_impuesto/100)), 6, ".", "");
            $array['detalle'][$i]['valor_impuesto'] = $empresa->valor_impuesto;

            $array['detalle'][$i]['subtotal'] = $row->precio_venta_neto;
            $array['detalle'][$i]['impuesto'] = $row->impuesto;

            $impuesto = $impuesto + $row->impuesto;
            $subtotal = $subtotal + $row->precio_venta_neto;
            $i++;
        }

        $array['comprobante']['subtotal'] = number_format($subtotal, 2, ".", "");
        $array['comprobante']['impuesto'] = number_format($impuesto, 2, ".", "");

        $array['carpeta'] = "comprobantes";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante']."-".$array['comprobante']['nombre'];

        crearComprobanteXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    public function crearNotaCredito($id){

        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $id , 'estado' => 1])->first();

        $venta = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_venta' => $nota->id_venta , 'estado' => 1])->first();
        $detalles = DetalleVenta::where(['id_venta' => $nota->id_venta, 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

            
        $array['comprobante']['total'] = $venta->total_venta;
        $array['comprobante']['nombre_cliente'] = $venta->cliente->nombre;
        $array['comprobante']['num_doc_cliente'] = $venta->cliente->numero_documento;
        $array['comprobante']['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo; // 01 FACTURA | 03 BOLETA
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;

        $array['nota']['nombre'] = $nota->nombre_nota;
        $array['nota']['fecha'] = $nota->fecha_emision;
        $array['nota']['hora'] = date("H:i:s", strtotime($nota->created_at));
        $array['nota']['id_motivo'] = $nota->id_motivo;
        $array['nota']['descripcion'] = $nota->descripcion;
        $array['nota']['tipo_comprobante'] = $nota->tipo_comprobante->codigo; // 07 NC | 08 ND

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;

        $impuesto = 0;
        $subtotal = 0;
        $i = 0;
        foreach ($detalles as $row) {
            
            $precio_unitario = $row->precio_venta_total/$row->cantidad;
            $array['detalle'][$i]['id_producto'] = $i+1;
            $array['detalle'][$i]['cantidad'] = $row->cantidad;
            $array['detalle'][$i]['descripcion'] = $row->descripcion;
            $array['detalle'][$i]['precio_unitario'] = number_format($precio_unitario, 2, ".", "");
            $array['detalle'][$i]['precio_unitario_neto'] = number_format($precio_unitario/(1+($empresa->valor_impuesto/100)), 6, ".", "");
            $array['detalle'][$i]['valor_impuesto'] = $empresa->valor_impuesto;

            $array['detalle'][$i]['subtotal'] = $row->precio_venta_neto;
            $array['detalle'][$i]['impuesto'] = $row->impuesto;

            $impuesto = $impuesto + $row->impuesto;
            $subtotal = $subtotal + $row->precio_venta_neto;
            $i++;
        }

        $array['comprobante']['subtotal'] = number_format($subtotal, 2, ".", ""); 
        $array['comprobante']['impuesto'] = number_format($impuesto, 2, ".", "");

        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['nota']['tipo_comprobante']."-".$array['nota']['nombre'];

        crearNotaCreditoXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    public function crearNotaDebito($id){

        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $id , 'estado' => 1])->first();

        $venta = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where(['id_venta' => $nota->id_venta , 'estado' => 1])->first();
        $detalles = DetalleVenta::where(['id_venta' => $nota->id_venta, 'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['total'] = $venta->total_venta;
        $array['comprobante']['nombre_cliente'] = $venta->cliente->nombre;
        $array['comprobante']['num_doc_cliente'] = $venta->cliente->numero_documento;
        $array['comprobante']['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo; // 1 DNI | 6 RUC
        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo; // 01 FACTURA | 03 BOLETA
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['comprobante']['valor_impuesto'] = $empresa->valor_impuesto; //OJOOO EL IGV PUEDE VARIAR EN EL FUTURO

        $array['nota']['nombre'] = $nota->nombre_nota;
        $array['nota']['fecha'] = $nota->fecha_emision;
        $array['nota']['hora'] = date("H:i:s", strtotime($nota->created_at));
        $array['nota']['id_motivo'] = $nota->id_motivo;
        $array['nota']['descripcion'] = $nota->descripcion;
        $array['nota']['tipo_comprobante'] = $nota->tipo_comprobante->codigo; // 07 NC | 08 ND

        $array['empresa']['ruc'] = $empresa->ruc;
        $array['empresa']['razon_social'] = $empresa->razon_social;
        $array['empresa']['representante'] = $empresa->representante;
        $array['empresa']['direccion'] = $empresa->direccion;
        $array['empresa']['ubigeo'] = $empresa->ubigeo;
        
        $subtotal = $venta->total_venta/(1+($empresa->valor_impuesto/100)); 
        $impuesto = $venta->total_venta - $subtotal;

        $array['comprobante']['subtotal'] = number_format($subtotal, 2, ".", ""); 
        $array['comprobante']['impuesto'] = number_format($impuesto, 2, ".", "");

        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['nota']['tipo_comprobante']."-".$array['nota']['nombre'];

        crearNotaDebitoXML($array);
        firmarComprobante($array);
        comprimirComprobante($array);
    }

    /*****************************************************************************************************************/
    /* ENVIO DE DOCUMENTOS
    /*****************************************************************************************************************/

    public function enviarFacturas()
    {
        //$ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        //$ayer = date('Y-m-j', $ayer);

        $ventas = Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('fecha_venta','<', date('Y-m-d'))->where('estado_envio','<>','ACEPTADO')->where('estado_envio','<>','RECHAZADO')->where([ 'id_tipo_comprobante' => 1,  'estado' => 1])->get();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        
        if (count($ventas) > 0) 
        {
            $i = 0;
            foreach ($ventas as $row) 
            {
                $array['comprobante']['tipo_comprobante'] = $row->tipo_comprobante->codigo;
                $array['comprobante']['serie'] = $row->serie_comprobante;
                $array['comprobante']['numero'] = $row->numero_comprobante;
                $array['comprobante']['nombre'] = $row->nombre_comprobante;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "comprobantes";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

                $send = enviarComprobante($array);
                if ($send['respuesta'] == "ENVIADO") {
                    $res = respuestaComprobante($array);
                    $estado  = $res["estado"];
                    $mensaje = $res["mensaje"];
                }
                if ($send['respuesta'] == "NO ENVIADO") {
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];
                }

                $data = Venta::find($row->id_venta);
                $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
            echo "- Facturas enviadas";

        } else{
            echo "- No hay Facturas para enviar";
        }
    }

    public function enviarNotas()
    {
        $notas = Nota::select('notas.id_nota', 'notas.nombre_nota', 'notas.serie_nota', 'notas.numero_nota', 'tipo_comprobante.codigo')->join('tipo_comprobante', 'tipo_comprobante.id_tipo_comprobante','=', 'notas.id_tipo_comprobante')->join('ventas', 'ventas.id_venta','=', 'notas.id_venta')->where([ 'ventas.estado_envio' => 'ACEPTADO' , 'ventas.id_tipo_comprobante' => 1, 'notas.estado' => 1])->where('notas.estado_envio','<>','ACEPTADO')->where('notas.estado_envio','<>','RECHAZADO')->get();

        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if (count($notas) > 0) 
        {
            $i = 0;
            foreach ($notas as $row) 
            {
                $array['comprobante']['tipo_comprobante'] = $row->codigo;
                $array['comprobante']['serie'] = $row->serie_nota;
                $array['comprobante']['numero'] = $row->numero_nota;
                $array['comprobante']['nombre'] = $row->nombre_nota;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "notas";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

                $send = enviarComprobante($array);
                if ($send['respuesta'] == "ENVIADO") {
                    $res = respuestaComprobante($array);
                    $estado  = $res["estado"];
                    $mensaje = $res["mensaje"];
                }
                if ($send['respuesta'] == "NO ENVIADO") {
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];
                }

                $data = Nota::find($row->id_nota);
                $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
            
            echo "- Notas de Facturas Enviadas";

        } else{
            echo "- No hay Notas de Facturas para Enviar";
        }
    }


    public function enviarResumen()
    {  
        $ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        $ayer = date('Y-m-d', $ayer);
        
        $today = date("Ymd");
        $hoy = date('Y-m-d');
        
        /*$ayer = '2018-11-17';
        $today = '20181117';
        $hoy = '2018-11-17';*/
        
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $ventas = Venta::with(['tipo_comprobante'])->where('fecha_venta','<', date('Y-m-d'))->where('estado_envio', 'REGISTRADO')->where(['id_tipo_comprobante' => 2, 'estado' => 1])->get(); 

        if (count($ventas) > 0) 
        {
            $array['comprobante']['tipo'] = 2; // 2 = BOLETA | 3 = NOTA CREDITO
            $array['comprobante']['fecha'] = $ayer;
            $array['resumen']['nombre'] = 'RC-'.$today.'-1';
            $array['resumen']['fecha'] = $hoy;
            $array['resumen']['local'] = 1;
 
            $array['empresa']['ruc'] = $empresa->ruc;
            $array['empresa']['razon_social'] = $empresa->razon_social;
            $array['empresa']['representante'] = $empresa->representante;
            $array['empresa']['direccion'] = $empresa->direccion;
            $array['empresa']['ubigeo'] = $empresa->ubigeo;

            $resumen = $this->registrarResumen($array);

            $i = 0;
            foreach ($ventas as $venta) 
            {
                $detalles = DetalleVenta::where(['id_venta' => $venta->id_venta, 'estado' => 1])->get();

                $array['boleta'][$i]['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
                $array['boleta'][$i]['nombre'] = $venta->nombre_comprobante;
                $array['boleta'][$i]['num_doc_cliente'] = $venta->cliente->numero_documento;
                $array['boleta'][$i]['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo;
                $array['boleta'][$i]['total'] = $venta->total_venta;

                $impuesto = 0;
                $subtotal = 0;

                foreach ($detalles as $row) 
                {
                    $impuesto = $impuesto + $row->impuesto;
                    $subtotal = $subtotal + $row->precio_venta_neto;
                }
                $array['boleta'][$i]['subtotal'] = number_format($subtotal, 2, ".", ""); 
                $array['boleta'][$i]['impuesto'] = number_format($impuesto, 2, ".", "");
                $i++;

                //Registramos Detalle Resumen
                $detalle_resumen= [
                    'id_resumen' => $resumen->id_resumen,
                    'id_venta' => $venta->id_venta,
                    'nombre_comprobante' => $venta->nombre_comprobante,
                    'subtotal' => number_format($subtotal, 2, ".", ""), 
                    'impuesto' => number_format($impuesto, 2, ".", ""), 
                ];
                DetalleResumen::create($detalle_resumen);
            }

            $array['carpeta'] = "resumen";
            $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

            crearResumenXML($array);
            firmarComprobante($array);
            comprimirComprobante($array);

            $send = enviarResumen($array);
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];

            //Actualizamos estados
            $resu = Resumen::find($resumen->id_resumen);
            $resu->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
            $resu->mensaje_envio   = $mensaje;
            $resu->save();

            foreach ($ventas as $venta) 
            {
                $data = Venta::find($venta->id_venta);
                $data->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO  
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }

            echo "- Envio de Resumen de Boletas Procesado";

        } 
        else {
            echo "- No hay Resumen de Boletas Para enviar";
        }    
    }

    public function enviarResumenNota()
    {  
        $ayer = strtotime('-1 day', strtotime(date('Y-m-d')));
        $ayer = date('Y-m-d', $ayer);
        
        $today = date("Ymd");
        $hoy = date('Y-m-d');
        
        /*$ayer = '2018-11-17';
        $today = '20181117';
        $hoy = '2018-11-17';*/
        
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
        $notas = Nota::join('ventas', 'notas.id_nota','=', 'ventas.id_nota')->where(function ($query) use ($ayer) {
                        $query->where('notas.fecha_emision', '<', date('Y-m-d'))
                              ->where('notas.estado_envio', '=',  'REGISTRADO')  
                              ->where('ventas.id_tipo_comprobante', '=',  2)
                              ->where('ventas.id_nota', '<>',  null);
                    })->get();

        if (count($notas) > 0) 
        {
            $array['comprobante']['tipo'] = 3; // 2 = BOLETA | 3 = NOTA CREDITO
            $array['comprobante']['fecha'] = $ayer;
            $array['resumen']['nombre'] = 'RC-'.$today.'-2';
            $array['resumen']['fecha'] = $hoy;
            $array['resumen']['local'] = 1;
 
            $array['empresa']['ruc'] = $empresa->ruc;
            $array['empresa']['razon_social'] = $empresa->razon_social;
            $array['empresa']['representante'] = $empresa->representante;
            $array['empresa']['direccion'] = $empresa->direccion;
            $array['empresa']['ubigeo'] = $empresa->ubigeo;

            //Registramos Resumen
            $resumen = $this->registrarResumen($array);

            $i = 0;
            foreach ($notas as $nota) 
            {
                $venta = Venta::with('nota')->where('id_venta', $nota->id_venta)->first(); 

                $detalles = DetalleVenta::where(['id_venta' => $venta->id_venta, 'estado' => 1])->get();

                $array['boleta'][$i]['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
                $array['boleta'][$i]['nombre'] = $venta->nombre_comprobante;
                $array['boleta'][$i]['num_doc_cliente'] = $venta->cliente->numero_documento;
                $array['boleta'][$i]['tipo_doc_cliente'] = $venta->cliente->tipo_documento->codigo;
                $array['boleta'][$i]['total'] = $venta->total_venta;

                $array['nota'][$i]['tipo_comprobante'] = $venta->nota->tipo_comprobante->codigo;
                $array['nota'][$i]['nombre'] = $venta->nota->nombre_nota;

                $impuesto = 0;
                $subtotal = 0;

                foreach ($detalles as $row) 
                {
                    $impuesto = $impuesto + $row->impuesto;
                    $subtotal = $subtotal + $row->precio_venta_neto;
                }
                $array['boleta'][$i]['subtotal'] = number_format($subtotal, 2, ".", ""); 
                $array['boleta'][$i]['impuesto'] = number_format($impuesto, 2, ".", "");
                $i++;

                //Registramos Detalle Resumen
                $detalle_resumen= [
                    'id_resumen' => $resumen->id_resumen,
                    'id_nota' => $venta->id_nota,
                    'nombre_comprobante' => $venta->nota->nombre_nota,
                    'subtotal' => number_format($subtotal, 2, ".", ""), 
                    'impuesto' => number_format($impuesto, 2, ".", ""), 
                ];
                DetalleResumen::create($detalle_resumen);
            }

            $array['carpeta'] = "resumen";
            $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

            crearResumenNota($array);
            firmarComprobante($array);
            comprimirComprobante($array);

            $send = enviarResumen($array);
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];

            //Actualizamos estados
            $resu = Resumen::find($resumen->id_resumen);
            $resu->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
            $resu->mensaje_envio   = $mensaje;
            $resu->save();

            foreach ($notas as $nota) 
            {
                $data = Nota::find($nota->id_nota);
                $data->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO  
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }

            echo "- Envio de Resumen de Notas Procesadas";
        } 
        else {
            echo "- No hay Resumen de Notas para Procesar";
        }
    }
   
   
    public function registrarResumen($array)
    {  
        $datos= [
            'id_local' => $array['resumen']['local'], 
            'nombre_resumen' => $array['resumen']['nombre'], // RC-20180715-1
            'fecha_emision' => $array['resumen']['fecha'], 
            'fecha_referencia' => $array['comprobante']['fecha'],
            'id_tipo_comprobante' => $array['comprobante']['tipo'],
        ];
        $res = Resumen::create($datos);
        return $res;
    }  

    

    /*****************************************************************************************************************/
    /* CONSULTA DE TICKETS
    /*****************************************************************************************************************/

    public function ticketResumen()
    {  
        $resumenes = Resumen::where('estado_envio','<>', 'ACEPTADO')->where(['estado' => 1])->get();  
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if (count($resumenes) > 0) 
        {
            foreach ($resumenes as $resumen) 
            {
                $array['resumen']['nombre'] = $resumen->nombre_resumen;
                $array['empresa']['ruc'] = $empresa->ruc;
                $array['carpeta'] = "resumen";
                $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

                if ($resumen->estado_envio == "PENDIENTE") 
                {
                    $send = consultaTicketResumen($array);
                    if ($send['respuesta'] == "ENVIADO") {
                        $res = respuestaResumen($array);
                        $estado  = $res["estado"];
                        $mensaje = $res["mensaje"];
                    }
                    if ($send['respuesta'] == "NO ENVIADO") {
                        $estado  = $send["estado"];
                        $mensaje = $send["mensaje"];
                    }

                    //Actualizamos estados
                    $resu = Resumen::find($resumen->id_resumen);
                    $resu->estado_envio    = $estado ; // ACEPTADO | RECHAZADO | NO ENVIADO 
                    $resu->mensaje_envio   = $mensaje;
                    $resu->save();

                    $detalles = DetalleResumen::where(['id_resumen' => $resumen->id_resumen , 'estado' => 1])->get();

                    if ($estado == "ACEPTADO" || $estado == "NO ENVIADO" ) {
                        foreach ($detalles as $venta) 
                        {
                            if ($resu->id_tipo_comprobante == 2) {
                                $data = Venta::find($venta->id_venta);
                            }
                            if ($resu->id_tipo_comprobante == 3) {
                                $data = Nota::find($venta->id_nota);
                            }
                            
                            $data->estado_envio    = $estado ; // ACEPTADO | NO ENVIADO 
                            $data->mensaje_envio   = $mensaje;
                            $data->save();
                        }
                    } else {
                        foreach ($detalles as $venta) 
                        {
                            if ($resu->id_tipo_comprobante == 2) {
                                $data = Venta::find($venta->id_venta);
                            }
                            if ($resu->id_tipo_comprobante == 3) {
                                $data = Nota::find($venta->id_nota);
                            }
                            $data->estado_envio    = "RECHAZADO";
                            $data->mensaje_envio   = $mensaje;
                            $data->save();
                        }
                    }
                }

                if ($resumen->estado_envio == "NO ENVIADO") 
                {
                    $send = enviarResumen($array);
                    $estado  = $send["estado"];
                    $mensaje = $send["mensaje"];

                    //Actualizamos estados
                    $resu = Resumen::find($resumen->id_resumen);
                    $resu->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
                    $resu->mensaje_envio   = $mensaje;
                    $resu->save();

                    $detalles = DetalleResumen::where(['id_resumen' => $resumen->id_resumen , 'estado' => 1])->get();

                    foreach ($detalles as $venta) 
                    {
                        if ($resu->id_tipo_comprobante == 2) {
                            $data1 = Venta::find($venta->id_venta);
                        }
                        if ($resu->id_tipo_comprobante == 3) {
                            $data1 = Nota::find($venta->id_nota);
                        }
                        
                        $data1->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO 
                        $data1->mensaje_envio   = $mensaje;
                        $data1->save();
                    }
                }
                    
            }   
            echo "- Obtencion de CDR de Resumenes Procesado";
        } 
        else {
            echo "- No hay Tickets de Resumenes para Procesar";
        }    
    }


    /*****************************************************************************************************************/
    /* REEEEENVIO DE DOCUMENTOS
    /*****************************************************************************************************************/
    public function reenviarFactura(Request $request)
    {  
        $this->crearComprobante($request->id);

        $venta = Venta::with(['tipo_comprobante'])->where(['id_venta' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
        $array['comprobante']['serie'] = $venta->serie_comprobante;
        $array['comprobante']['numero'] = $venta->numero_comprobante;
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "comprobantes";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

        $send = enviarComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        $data = Venta::find($venta->id_venta);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }


    public function reenviarNota(Request $request)
    {  
        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        if ($nota->id_tipo_comprobante == 3) {
            $this->crearNotaCredito($request->id);
        }
        if ($nota->id_tipo_comprobante == 4) {
            $this->crearNotaDebito($request->id);
        }

        $array['comprobante']['tipo_comprobante'] = $nota->tipo_comprobante->codigo;
        $array['comprobante']['serie'] = $nota->serie_nota;
        $array['comprobante']['numero'] = $nota->numero_nota;
        $array['comprobante']['nombre'] = $nota->nombre_nota;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante'] ."-".$array['comprobante']['nombre'];

    
        $send = enviarComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $data = Nota::find($nota->id_nota);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }


    public function reenviarResumen(Request $request)
    {  
        $resumen = Resumen::find($request->id);
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['resumen']['nombre'] = $resumen->nombre_resumen;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "resumen";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];
      
        $send = enviarResumen($array); 
        $estado  = $send["estado"];
        $mensaje = $send["mensaje"];

        //Actualizamos estados
        $resumen->estado_envio    = $estado ; //PENDIENTE | NO ENVIADO
        $resumen->mensaje_envio   = $mensaje;
        $resumen->save();

        $detalles =  DetalleResumen::where(['id_resumen' => $resumen->id_resumen, 'estado' => 1])->get();

        foreach ($detalles as $venta) 
        {
            if ($resumen->id_tipo_comprobante == 2) {
                $data = Venta::find($venta->id_venta);
            }
            if ($resumen->id_tipo_comprobante == 3) {
                $data = Nota::find($venta->id_nota);
            }
            $data->estado_envio    = $estado ; // PENDIENTE | NO ENVIADO
            $data->mensaje_envio   = $mensaje;
            $data->save();
        }
        return response()->json($send['estado'] == "PENDIENTE" ? ['message' => 'success'] : ['message' => 'error']); 
    }


    /*****************************************************************************************************************/
    /* OBTENER CDR DE UN RESUMEN
    /*****************************************************************************************************************/

    public function cdrResumen(Request $request)
    {  
        $resumen = Resumen::find($request->id);
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();
       
        $array['resumen']['nombre'] = $resumen->nombre_resumen;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "resumen";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['resumen']['nombre'];

        $send = consultaTicketResumen($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaResumen($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $resumen->estado_envio    = $estado ; // ACEPTADO | RECHAZADO | NO ENVIADO 
        $resumen->mensaje_envio   = $mensaje;
        $resumen->save();

        $detalles =  DetalleResumen::where(['id_resumen' => $resumen->id_resumen, 'estado' => 1])->get();

        if ($estado == "ACEPTADO" || $estado == "NO ENVIADO") {
            foreach ($detalles as $venta) 
            {
                if ($resumen->id_tipo_comprobante == 2) {
                    $data = Venta::find($venta->id_venta);
                }
                if ($resumen->id_tipo_comprobante == 3) {
                    $data = Nota::find($venta->id_nota);
                }
                $data->estado_envio    = $estado ; // ACEPTADO | NO ENVIADO 
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
        } else {
            foreach ($detalles as $venta) 
            {
                if ($resumen->id_tipo_comprobante == 2) {
                    $data = Venta::find($venta->id_venta);
                }
                if ($resumen->id_tipo_comprobante == 3) {
                    $data = Nota::find($venta->id_nota);
                }
                $data->estado_envio    = "RECHAZADO";
                $data->mensaje_envio   = $mensaje;
                $data->save();
            }
        }
        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }

    public function cdrFactura(Request $request)
    {  
        $venta = Venta::with(['tipo_comprobante'])->where(['id_venta' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo_comprobante'] = $venta->tipo_comprobante->codigo;
        $array['comprobante']['nombre'] = $venta->nombre_comprobante;
        $array['comprobante']['numero'] = $venta->numero_comprobante;
        $array['comprobante']['serie'] = $venta->serie_comprobante;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "comprobantes";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante']."-".$array['comprobante']['nombre'];

        $send = consultaCdrComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        $data = Venta::find($venta->id_venta);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }


    public function cdrNota(Request $request)
    {  
        $nota = Nota::with('tipo_comprobante')->where(['id_nota' => $request->id , 'estado' => 1])->first();
        $empresa = Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first();

        $array['comprobante']['tipo_comprobante'] = $nota->tipo_comprobante->codigo;
        $array['comprobante']['nombre'] = $nota->nombre_nota;
        $array['comprobante']['numero'] = $nota->numero_nota;
        $array['comprobante']['serie'] = $nota->serie_nota;
        $array['empresa']['ruc'] = $empresa->ruc;
        $array['carpeta'] = "notas";
        $array['archivo'] = $array['empresa']['ruc']."-".$array['comprobante']['tipo_comprobante']."-".$array['comprobante']['nombre'];
    
        $send = consultaCdrComprobante($array);
        if ($send['respuesta'] == "ENVIADO") {
            $res = respuestaComprobante($array);
            $estado  = $res["estado"];
            $mensaje = $res["mensaje"];
        }
        if ($send['respuesta'] == "NO ENVIADO") {
            $estado  = $send["estado"];
            $mensaje = $send["mensaje"];
        }

        //Actualizamos estados
        $data = Nota::find($nota->id_nota);
        $data->estado_envio    = $estado ; // ACEPTADO | RECHAZADO 
        $data->mensaje_envio   = $mensaje;
        $data->save();

        return response()->json($send['respuesta'] == "ENVIADO" ? ['message' => 'success'] : ['message' => 'error']); 
    }



}