<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cliente extends Model
{
    protected $table = 'clientes';
    protected $primaryKey = 'id_cliente';

    protected $fillable = [
        'id_cliente', 'id_tipo_documento','nombre', 'numero_documento', 'direccion', 'email', 'telefono', 'estado'
    ];

    public function tipo_documento()
    {
        return $this->belongsTo('App\Models\TipoDocumento', 'id_tipo_documento');
    }
}
