<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleHospedar extends Model
{
    protected $table = 'detalle_hospedar';
    protected $primaryKey = 'id_detalle_hospedar';

    protected $fillable = [
        'id_detalle_hospedar', 'id_hospedar','id_huesped', 'motivo', 'papeleta', 'estado'
    ];

    public function hospedar()
    {
        return $this->belongsTo('App\Models\Hospedar', 'id_hospedar');
    }
    public function huesped()
    {
        return $this->belongsTo('App\Models\Huesped', 'id_huesped');
    }
}
