<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleResumen extends Model
{
    protected $table = 'detalle_resumen';
    protected $primaryKey = 'id_detalle_resumen';

    protected $fillable = [
        'id_detalle_resumen', 'id_resumen','id_venta', 'id_nota', 'nombre_comprobante', 'subtotal', 'impuesto', 'estado'
    ];

    public function resumen()
    {
        return $this->belongsTo('App\Models\Resumen', 'id_resumen');
    }
    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }
    public function nota()
    {
        return $this->belongsTo('App\Models\Nota', 'id_nota');
    }
}
