<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleVenta extends Model
{
    protected $table = 'detalle_venta';
    protected $primaryKey = 'id_detalle_venta';

    protected $fillable = [
        'id_detalle_venta','id_venta','descripcion', 'cantidad', 'precio_venta', 'impuesto', 'precio_venta_neto', 'descuento', 'precio_venta_total', 'estado'
    ];

    public function venta()
    {
        return $this->belongsTo('App\Models\Compra', 'id_venta');
    }

}
