<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Habitacion extends Model
{
    protected $table = 'habitaciones';
    protected $primaryKey = 'id_habitacion';

    protected $fillable = [
        'id_habitacion','id_tipo_habitacion', 'id_local', 'numero', 'descripcion', 'precio', 'situacion', 'estado'
    ];

    public function tipo_habitacion()
    {
        return $this->belongsTo('App\Models\TipoHabitacion', 'id_tipo_habitacion');
    }

    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
}
