<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Hospedar extends Model
{
    protected $table = 'hospedar';
    protected $primaryKey = 'id_hospedar';

    protected $fillable = [
        'id_hospedar','id_habitacion', 'id_usuario', 'id_local', 'id_venta', 'fecha_ingreso', 'fecha_salida', 'observacion', 'adelanto','estado'
    ];

    public function habitacion()
    {
        return $this->belongsTo('App\Models\Habitacion', 'id_habitacion');
    }

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }

    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }

    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }

}
