<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Nota extends Model
{
    protected $table = 'notas';
    protected $primaryKey = 'id_nota';

    protected $fillable = [
        'id_nota', 'id_venta','id_usuario', 'id_local', 'id_tipo_comprobante', 'serie_nota', 'numero_nota', 'nombre_nota', 'fecha_emision', 'id_motivo', 'motivo', 'descripcion', 'contingencia','estado_envio', 'mensaje_envio', 'estado'
    ];

    
    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }
    public function tipo_comprobante()
    {
        return $this->belongsTo('App\Models\TipoComprobante', 'id_tipo_comprobante');
    }
    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
}
