<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Proforma extends Model
{
    protected $table = 'proformas';
    protected $primaryKey = 'id_proforma';

    protected $fillable = [
        'id_proforma', 'id_usuario','id_local', 'nombre', 'numero_documento', 'direccion', 'fecha_emision', 'total', 'observacion', 'adelanto', 'saldo', 'estado'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
}
