<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Reserva extends Model
{
    protected $table = 'reservas';
    protected $primaryKey = 'id_reserva';

    protected $fillable = [
        'id_reserva','id_habitacion', 'id_usuario', 'id_local', 'nombre', 'dni', 'email', 'telefono', 'fecha_llegada', 'observacion', 'medio', 'estado'
    ];

    public function habitacion()
    {
        return $this->belongsTo('App\Models\Habitacion', 'id_habitacion');
    }

    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
}
