<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resumen extends Model
{
    protected $table = 'resumenes';
    protected $primaryKey = 'id_resumen';

    protected $fillable = [
        'id_resumen', 'id_local', 'id_tipo_comprobante', 'nombre_resumen','fecha_emision', 'fecha_referencia', 'estado_envio', 'mensaje_envio', 'estado'
    ];

    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }

        public function tipo_comprobante()
    {
        return $this->belongsTo('App\Models\TipoComprobante', 'id_tipo_comprobante');
    }

}
