<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHabitacionesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('habitaciones', function (Blueprint $table) {
            $table->integer('id_habitacion')->autoIncrement();
            $table->integer('id_tipo_habitacion');
            $table->integer('id_local');
            $table->integer('numero');
            $table->string('descripcion', 100)->nullable();
            $table->decimal('precio', 9, 2)->nullable();
            $table->string('situacion', 20)->default('DISPONIBLE'); // DISPONIBLE - OCUPADO - MANTENIMIENTO
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_tipo_habitacion')->references('id_tipo_habitacion')->on('tipo_habitacion'); 
            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade'); 
  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('habitaciones');
    }
}
