<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHuespedesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('huespedes', function (Blueprint $table) {
            $table->integer('id_huesped')->autoIncrement();
            $table->string('nombre', 200)->nullable();
            $table->string('dni', 15)->nullable();
            $table->string('ocupacion', 50)->nullable();
            $table->string('genero', 15)->nullable();
            $table->date('fecha_nacimiento')->nullable();
            $table->string('email', 100)->nullable();
            $table->string('telefono', 20)->nullable();
            $table->string('pais', 50)->nullable();
            $table->string('ciudad', 50)->nullable();

            $table->string('razon_social', 200)->nullable();
            $table->string('ruc', 15)->nullable();
            $table->string('direccion_empresa', 200)->nullable();

            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('huespedes');
    }
}
