<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHospedarTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hospedar', function (Blueprint $table) {
            $table->integer('id_hospedar')->autoIncrement();
            $table->integer('id_habitacion');
            $table->integer('id_usuario');
            $table->integer('id_local');
            $table->integer('id_venta')->nullable();
            $table->dateTime('fecha_ingreso')->nullable();
            $table->dateTime('fecha_salida')->nullable();
            $table->string('observacion', 100)->nullable(); 
            $table->decimal('adelanto', 9, 2)->nullable();
            $table->tinyInteger('estado')->default('1'); // 0 - TERMINADO | 1 OCUPADO ACTUAL
            $table->timestamps();

            $table->foreign('id_habitacion')->references('id_habitacion')->on('habitaciones'); 
            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios'); 
            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hospedar');
    }
}
