<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleHospedarTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_hospedar', function (Blueprint $table) {
            $table->integer('id_detalle_hospedar')->autoIncrement();
            $table->integer('id_hospedar');
            $table->integer('id_huesped')->nullable();
            $table->string('motivo', 20)->nullable();
            $table->string('papeleta', 15)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_hospedar')->references('id_hospedar')->on('hospedar'); 
            $table->foreign('id_huesped')->references('id_huesped')->on('huespedes'); 

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_hospedar');
    }
}
