<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clientes', function (Blueprint $table) {
            $table->integer('id_cliente')->autoIncrement();
            $table->integer('id_tipo_documento')->nullable();
            $table->string('nombre', 200)->nullable();
            $table->string('numero_documento', 15)->nullable();
            $table->string('direccion', 100)->nullable();
            $table->string('email', 100)->nullable();
            $table->string('telefono', 15)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_tipo_documento')->references('id_tipo_documento')->on('tipo_documento');   
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clientes');
    }
}
