<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleVentaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_venta', function (Blueprint $table) {
            $table->integer('id_detalle_venta')->autoIncrement();
            $table->integer('id_venta');
            $table->string('descripcion', 200)->nullable();
            $table->decimal('cantidad', 9, 2);
            $table->decimal('precio_venta', 9, 2);
            $table->decimal('impuesto', 9, 2);
            $table->decimal('precio_venta_neto', 9, 2);
            $table->decimal('descuento', 9, 2);
            $table->decimal('precio_venta_total', 9, 2);
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
            
            $table->foreign('id_venta')
                  ->references('id_venta')->on('ventas')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');   
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_venta');
    }
}
