<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmpresaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('empresa', function (Blueprint $table) {
            $table->integer('id_empresa')->autoIncrement();
            $table->string('razon_social', 200);
            $table->string('ruc', 11);
            $table->string('representante', 100);
            $table->string('dni', 8);
            $table->string('autorizacion', 50);
            $table->string('direccion', 100);
            $table->string('telefono', 15)->nullable();
            $table->string('pagina_web', 50)->nullable();
            $table->string('email', 50)->nullable();
            $table->string('ubigeo', 10)->nullable();
            $table->decimal('valor_impuesto', 9, 2);
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('empresa');
    }
}
