<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateResumenesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('resumenes', function (Blueprint $table) {
            $table->integer('id_resumen')->autoIncrement();
            $table->integer('id_local')->nullable();
            $table->integer('id_tipo_comprobante')->nullable();
            $table->string('nombre_resumen', 30)->nullable(); //RC-20180714-1
            $table->date('fecha_emision')->nullable();
            $table->date('fecha_referencia', 10)->nullable();
            $table->string('estado_envio', 15)->nullable(); // ACEPTADO, NO ENVIADO, RECHAZADO
            $table->string('mensaje_envio', 500)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_local')->references('id_local')->on('local'); 
             
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('resumenes');
    }
}
