<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleResumenTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_resumen', function (Blueprint $table) {
            $table->integer('id_detalle_resumen')->autoIncrement();
            $table->integer('id_resumen');
            $table->integer('id_venta')->nullable(); 
            $table->integer('id_nota')->nullable(); 
            $table->string('nombre_comprobante', 15)->nullable(); 
            $table->decimal('subtotal', 9, 2)->nullable(); 
            $table->decimal('impuesto', 9, 2)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_resumen')
                  ->references('id_resumen')->on('resumenes')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');
            $table->foreign('id_venta')->references('id_venta')->on('ventas'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_resumen');
    }
}
