<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReservasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reservas', function (Blueprint $table) {
            $table->integer('id_reserva')->autoIncrement();
            $table->integer('id_habitacion')->nullable();
            $table->integer('id_usuario')->nullable();
            $table->integer('id_local')->nullable();

            $table->string('nombre', 200)->nullable();
            $table->string('dni', 15)->nullable();
            $table->string('email', 100)->nullable();
            $table->string('telefono', 20)->nullable();

            $table->date('fecha_llegada')->nullable();
            $table->string('observacion', 50)->nullable(); // VENCIDO | PENDIENTE | CANCELADO | REGISTRADO
            $table->string('medio', 50)->nullable(); // TELEFONO | PERSONALMENTE | PAGINA WEB | OTRO
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_habitacion')->references('id_habitacion')->on('habitaciones'); 
            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios'); 
            $table->foreign('id_local')->references('id_local')->on('local'); 

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reservas');
    }
}
