<?php 
 ob_start();
    header('Content-Type: text/html; charset=UTF-8');
    require("fpdf/fpdf.php");
    require_once ("PDF417/vendor/autoload.php");
    require("phpmailer/src/PHPMailer.php");
    require("phpmailer/src/Exception.php");
    use BigFish\PDF417\PDF417;
    use BigFish\PDF417\Renderers\ImageRenderer;
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    include ("config.php");

    /******************************************************************************************/
    /* clase PDF
    /******************************************************************************************/
    class PDF extends FPDF{
        
        function Footer(){
            
            $this->SetTextColor(0,0,0);
            $this->SetFont('helvetica','',8);
            $this->SetXY(18,26.2);
            //$this->Cell(0.8, 0.25, utf8_decode("Pág. ").$this->PageNo().' de {nb}', 0, 1,'L', 0);
        }

        function GetMultiCellHeight($w, $h, $txt, $border=null, $align='J') {
            // Calculate MultiCell with automatic or explicit line breaks height
            // $border is un-used, but I kept it in the parameters to keep the call
            //   to this function consistent with MultiCell()
            $cw = &$this->CurrentFont['cw'];
            if($w==0)
                $w = $this->w-$this->rMargin-$this->x;
            $wmax = ($w-2*$this->cMargin)*1000/$this->FontSize;
            $s = str_replace("\r",'',$txt);
            $nb = strlen($s);
            if($nb>0 && $s[$nb-1]=="\n")
                $nb--;
            $sep = -1;
            $i = 0;
            $j = 0;
            $l = 0;
            $ns = 0;
            $height = 0;
            while($i<$nb)
            {
                // Get next character
                $c = $s[$i];
                if($c=="\n")
                {
                    // Explicit line break
                    if($this->ws>0)
                    {
                        $this->ws = 0;
                        $this->_out('0 Tw');
                    }
                    //Increase Height
                    $height += $h;
                    $i++;
                    $sep = -1;
                    $j = $i;
                    $l = 0;
                    $ns = 0;
                    continue;
                }
                if($c==' ')
                {
                    $sep = $i;
                    $ls = $l;
                    $ns++;
                }
                $l += $cw[$c];
                if($l>$wmax)
                {
                    // Automatic line break
                    if($sep==-1)
                    {
                        if($i==$j)
                            $i++;
                        if($this->ws>0)
                        {
                            $this->ws = 0;
                            $this->_out('0 Tw');
                        }
                        //Increase Height
                        $height += $h;
                    }
                    else
                    {
                        if($align=='J')
                        {
                            $this->ws = ($ns>1) ? ($wmax-$ls)/1000*$this->FontSize/($ns-1) : 0;
                            $this->_out(sprintf('%.3F Tw',$this->ws*$this->k));
                        }
                        //Increase Height
                        $height += $h;
                        $i = $sep+1;
                    }
                    $sep = -1;
                    $j = $i;
                    $l = 0;
                    $ns = 0;
                }
                else
                    $i++;
            }
            // Last chunk
            if($this->ws>0)
            {
                $this->ws = 0;
                $this->_out('0 Tw');
            }
            //Increase Height
            $height += $h;

            return $height;
        }
    }

    /******************************************************************************************/
    /* consultas SQL
    /******************************************************************************************/

    $id = $_GET['id_venta'];

    $mysqli = new mysqli($db_host,$db_user,$db_pass,$db_name);

    //Para obtener los datos de la venta
    $query1 = "SELECT * FROM ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente WHERE id_venta = '".$id."' ";
    $result1 = $mysqli->query($query1);
    $row1 = $result1->fetch_assoc();

    //Para obtener los detalles de la venta
    $query2 = "SELECT * FROM detalle_venta d INNER JOIN productos p ON d.id_producto = p.id_producto WHERE id_venta = '".$id."' ";
    $result2 = $mysqli->query($query2);

    //Para obtener los datos de la empresa
    $query3 = "SELECT * FROM empresa WHERE id_empresa = '1' ";
    $result3 = $mysqli->query($query3);
    $row3 = $result3->fetch_assoc();

    //Para obtener los datos del tipo de comprobante
    $query4 = "SELECT t.* FROM ventas v INNER JOIN tipo_comprobante t ON v.id_tipo_comprobante = t.id_tipo_comprobante WHERE id_venta = '".$id."' ";
    $result4 = $mysqli->query($query4);
    $row4 = $result4->fetch_assoc();



    // Variables correspondientes a la factura.
    $RUC        = $row1['numero_documento'];    // RUC.
    $NomRazSoc  = $row1['nombre'];              // Nombre o Razón social.
    $FecEmi     = $row1['fecha_venta'];         // Fecha de emisión.
    $Domicilio  = $row1['direccion'];           // Domicilio.
    $CodHash    = "";                           // Código Hash.
    $TipoDoc    = $row1['id_tipo_comprobante']; // Tipo de documento.
    $TotGrav    = 0;                            // Total gravado.
    $TotIGV     = 0;                            // Total IGV.
    $TotMonto   = 0;                            // Total importe. 
    $autoriza   = $row3['autorizacion'];
    $pagina     = $row3['pagina_web'];

    $xml = file_get_contents('../sunat/xml/comprobantes/'.$row3['ruc'].'-'.$row4['codigo'].'-'.$row1['nombre_comprobante'].'.xml');
    // Obteniendo datos del archivo .XML 
    $DOM = new DOMDocument('1.0', 'ISO-8859-1');
    $DOM->preserveWhiteSpace = FALSE;
    $DOM->loadXML($xml);

   // Obteniendo Codigo Hash
    $DocXML = $DOM->getElementsByTagName('DigestValue');
    $i=0;
    foreach($DocXML as $Nodo){
        if ($i==0){
            $CodHash = $Nodo->nodeValue; 
        }
        $i++;
    } 
   
    // TOTALES DE LA FACTURA 
    
    $sub_total = 0;
    $total = 0;
    $igv = 0;
    $desc = 0;
    $ii=0;
    while($row2 = $result2->fetch_assoc()){

        
        $array['detalle'][$ii]['descripcion'] = $row2['nombre']; 
        $array['detalle'][$ii]['cantidad'] = number_format($row2['cantidad'] , 2, ".", ""); 
        $array['detalle'][$ii]['precio_unitario'] = number_format($row2['precio_venta'], 2, ".", ""); 
        $array['detalle'][$ii]['subtotal'] = number_format($row2['precio_venta_total'] , 2, ".", ""); 
        $array['detalle'][$ii]['descuento'] = number_format($row2['descuento'] , 2, ".", ""); 
        $array['detalle'][$ii]['total'] = number_format($row2['cantidad']*$row2['precio_venta'] , 2, ".", ""); 
        $sub_total = $sub_total + $row2['precio_venta_neto'];
        $igv = $igv + $row2['impuesto'];
        $ii++;
    }

    $TotGrav = number_format($sub_total, 2, '.', '');
    $TotIGV = number_format($igv, 2, '.', '');
    $TotMonto = number_format($row1['total_venta'], 2, '.', '');       


    // Crear el gráfico con el código de barras
    $nom_f = $row1['nombre_comprobante'];
    $tip_f = $row4['nombre'];
    $ruc_e = $row3['ruc'];
    $textoCodBar = "
        | RUC : $ruc_e
        | $tip_f
        | $nom_f
        | SUBTOTAL : $TotGrav
        | IGV : $TotIGV
        | TOTAL : $TotMonto
        | $FecEmi
        | $CodHash
        ";

    $pdf417 = new PDF417();
    $codigo_barra = $pdf417->encode($textoCodBar);
    // Create a PNG image
    $renderer = new ImageRenderer( ['format' => 'png'] );
    $image = $renderer->render($codigo_barra);
    $image->save('image/image_hash.png');
 

    /******************************************************************************************/
    /* creamos documento PDF
    /******************************************************************************************/

    $pdf=new PDF('P','cm','Letter');
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->AddFont('IDAutomationHC39M','','IDAutomationHC39M.php');
    $pdf->AddFont('verdana','','verdana.php');
    $pdf->SetAutoPageBreak(true);
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetLineWidth(0.02);
    $pdf->SetFillColor(0,0,0);

       
    //$pdf->image("../sunat/archs_graf/Membrete_Fact_2.jpg",1, 1, 10, 2.5);
    $pdf->RoundedRect(1, 1, 10, 2.5, 0.2, ''); 

    $pdf->SetTextColor(0,0,150);
    $pdf->SetFont('arial','',12);
    $pdf->SetXY(1,1.4);
    $pdf->MultiCell(10, 0.4, $row3['razon_social'], 0, "C", 0);
    
    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','B',9);
    $pdf->SetXY(1,2.9);
    $pdf->MultiCell(10, 0.3, "".$row3['direccion']."   Telf: ".$row3['telefono']."", 0,'C', 0);

    $pdf->RoundedRect(12, 1, 8, 2.5, 0.2, ''); 

    $pdf->SetTextColor(170,0,0);
    $pdf->SetFont('arial','',14);
    $pdf->SetXY(12,1.5);
    $pdf->Cell(8, 0.25, "RUC: ".$row3['ruc']."", 0, 1,'C', 0);

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','B',13);
    $pdf->SetXY(12,2.2);
    $pdf->Cell(8, 0.25, utf8_decode($row4['nombre']." ELECTRÓNICA"), 0, 1,'C', 0); 

    $pdf->SetTextColor(0,0,150);
    $pdf->SetFont('arial','',14);
    $pdf->SetXY(12,2.9);
    $pdf->Cell(8, 0.25, $row1['nombre_comprobante'], 0, 1,'C', 0); 


    $pdf->RoundedRect(1, 4, 19, 3.2, 0.2, ''); 

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','B',10);


    if ($row4['nombre'] == "FACTURA") {
        $pdf->SetXY(1.1,4.2);
        $pdf->Cell(1, 0.35, utf8_decode("Razon Social: "), 0, 1,'L', 0);

        $pdf->SetXY(1.1,4.2+(0.6*2));
        $pdf->Cell(1, 0.35, utf8_decode("RUC: "), 0, 1,'L', 0);
    }
    else {
        $pdf->SetXY(1.1,4.2);
        $pdf->Cell(1, 0.35, utf8_decode("Señor(es): "), 0, 1,'L', 0);

        $pdf->SetXY(1.1,4.2+(0.6*2));
        $pdf->Cell(1, 0.35, utf8_decode("DNI: "), 0, 1,'L', 0);
    }

    $pdf->SetXY(1.1,4.2+0.6);
    $pdf->Cell(1, 0.35, utf8_decode("Dirección: "), 0, 1,'L', 0);

    $pdf->SetXY(1.1,4.2+(0.6*3));
    $pdf->Cell(1, 0.35, utf8_decode("Fecha de emisión: "), 0, 1,'L', 0);

    $pdf->SetXY(1.1,4.2+(0.6*4));
    $pdf->Cell(1, 0.35, utf8_decode("Moneda: "), 0, 1,'L', 0);


    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','',10);

    $pdf->SetXY(4.7,4.2);
    $pdf->Cell(1, 0.35, $NomRazSoc, 0, 1,'L', 0);

    $pdf->SetXY(4.7,4.2+0.6);
    $pdf->Cell(1, 0.35, $Domicilio, 0, 1,'L', 0);

    $pdf->SetXY(4.7,4.2+(0.6*2));
    $pdf->Cell(1, 0.35, utf8_decode($RUC), 0, 1,'L', 0);

    $pdf->SetXY(4.7,4.2+(0.6*3));
    $pdf->Cell(1, 0.35, utf8_decode($FecEmi), 0, 1,'L', 0);

    $pdf->SetXY(4.7,4.2+(0.6*4));
    $pdf->Cell(1, 0.35, utf8_decode("SOL"), 0, 1,'L', 0);


    // TITULO correspondientes a los productos o servicios de la factura.
    
    $X = 0;
    $Y = 0;

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','B',10);

    $pdf->SetXY($X+1,$Y+8);
    $pdf->Cell(2.5, 0.5, utf8_decode("Cantidad"), 1, 1,'C', 0);

    $pdf->SetXY($X+3.5,$Y+8);
    $pdf->Cell(11.3, 0.5, utf8_decode("Descripción"), 1, 1,'C', 0);

    $pdf->SetXY($X+12.1,$Y+8);
    $pdf->Cell(2.7, 0.5, utf8_decode("Precio"), 1, 1,'C', 0);

    $pdf->SetXY($X+14.8,$Y+8);
    $pdf->Cell(2.7, 0.5, utf8_decode("Descuento"), 1, 1,'C', 0);

    $pdf->SetXY($X+17.5,$Y+8);
    $pdf->Cell(2.5, 0.5, utf8_decode("Importe"), 1, 1,'C', 0);

    // Variables correspondientes a los productos o servicios de la factura
    
    $pdf->SetFont('arial','',10);
    $Y = $Y + 0.5;
    $Y1 = 0;
    for ($i=0; $i < sizeof($array['detalle']) ; $i++) { 
        
        $h_descrip = $pdf->GetMultiCellHeight(8.6, 0.5, utf8_decode($array['detalle'][$i]['descripcion']), $border=null, $align='L'); 
        
        $pdf->SetXY($X+1,$Y+8+$Y1);
        $pdf->Cell(2.5, $h_descrip, utf8_decode($array['detalle'][$i]['cantidad']), 1, 1,'C', 0);

        $pdf->SetXY($X+3.5,$Y+8+$Y1);
        $pdf->MultiCell(8.6, 0.5, $array['detalle'][$i]['descripcion'] , 1, "L", 0);
        
        $pdf->SetXY($X+12.1,$Y+8+$Y1);
        $pdf->Cell(2.7, $h_descrip, number_format($array['detalle'][$i]['precio_unitario'],2), 1, 1,'R', 0);

        $pdf->SetXY($X+14.8,$Y+8+$Y1);
        $pdf->Cell(2.7, $h_descrip, "-".number_format($array['detalle'][$i]['descuento'],2), 1, 1,'R', 0);

        $pdf->SetXY($X+17.5,$Y+8+$Y1);
        $pdf->Cell(2.5, $h_descrip, number_format($array['detalle'][$i]['subtotal'],2), 1, 1,'R', 0);

         $Y1 = $Y1 + $h_descrip;
         
         
        /*
        $pdf->SetXY($X+1,$Y+8+$Y1);
        $pdf->Cell(2.5, 0.8, utf8_decode($array['detalle'][$i]['cantidad']), 1, 1,'C', 0);

        $pdf->SetXY($X+3.5,$Y+8+$Y1);
        $pdf->Cell(11.3, 0.8, utf8_decode($array['detalle'][$i]['descripcion']), 1, 1,'L', 0);

        $pdf->SetXY($X+14.8,$Y+8+$Y1);
        $pdf->Cell(2.7, 0.8, number_format($array['detalle'][$i]['precio_unitario'],2), 1, 1,'R', 0);

        $pdf->SetXY($X+17.5,$Y+8+$Y1);
        $pdf->Cell(2.5, 0.8, number_format($array['detalle'][$i]['total'],2), 1, 1,'R', 0);

        $Y1 = $Y1 + 0.8;*/
    }   

    $pdf->image('image/image_hash.png',0.7, 10+$Y1-1, 9, 3); 

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','',10);
    $pdf->SetXY(1.2,13+$Y1-1);
    $pdf->Cell(8, 0.25, utf8_decode("Representación impresa de la factura electrónica."), 0, 1,'C', 0);

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','',10);

    $pdf->SetXY(9.9,10+$Y1-1);
    $pdf->Cell(7.6, 0.5, utf8_decode("Valor de Venta - Operaciones Gravadas       S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,10+$Y1-1);
    $pdf->Cell(2.5, 0.5, number_format($TotGrav,2), 1, 1,'R', 0);

    $pdf->SetXY(9.9,10+0.5+$Y1-1);
    $pdf->Cell(7.6, 0.5, utf8_decode("IGV       S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,10+0.5+$Y1-1);
    $pdf->Cell(2.5, 0.5, number_format($TotIGV,2), 1, 1,'R', 0);

    $pdf->SetFont('arial','B',10.5);
    $pdf->SetXY(9.9,10+(0.5*2)+$Y1-1);
    $pdf->Cell(7.6, 0.5, utf8_decode("Importe Total       S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,10+(0.5*2)+$Y1-1);
    $pdf->Cell(2.5, 0.5, number_format($TotMonto,2), 1, 1,'R', 0);

    $pdf->line(1, 24.8, 20.5, 24.8);

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('arial','',9);
    $pdf->SetXY(1,25);
    $pdf->MultiCell(19.5, 0.35, utf8_decode("Representación Impresa de la Factura Electrónica \n\n Código Hash: $CodHash
    Autorizado para ser Emisor Electrónico mediante la Resolución de Intendencia N° $autoriza \n $pagina  \n GRACIAS POR SU PREFERENCIA!!"), 0, 'C');

    //==============================================================================
    
    
    $NomArchPDF = "comprobante.pdf";    
    $pdf->Output($NomArchPDF, 'F'); // Se graba el documento .PDF en el disco duro o unidad de estado sólido.
    chmod ($NomArchPDF,0777);  // Se dan permisos de lectura y escritura.

    
    
    if (isset($_GET['email_cliente']))  {
        $mail = new PHPMailer();  
        try {
            $mail->setFrom($row3['email'], $row3['razon_social']);
            $mail->Subject = "Comprobante Electronico";
            $mail->Body = "Estimado cliente le adjuntamos su comprobante electronico, gracias por su preferencia!!";
            $mail->addAddress($_GET['email_cliente'], "Cliente");
            $archivo = 'comprobante.pdf';
            $archivo_xml = '../sunat/xml/comprobantes/'.$row3['ruc'].'-'.$row4['codigo'].'-'.$row1['nombre_comprobante'].'.xml';
            $mail->addAttachment($archivo);
            $mail->addAttachment($archivo_xml);
            $mail->send(); 
            $pdf->Output($NomArchPDF, 'I'); // Se muestra el documento .PDF en el navegador.   
        } catch (Exception $e) {
            echo 'Correo no se pudo enviar. Mensaje de Error: ', $mail->ErrorInfo;
        }   
    }
        
    unlink('image/image_hash.png');
ob_end_flush(); 