<?php 
 ob_start();
    header('Content-Type: text/html; charset=UTF-8');
    require("fpdf/fpdf.php");
    require_once("PDF417/vendor/autoload.php");
    use BigFish\PDF417\PDF417;
    use BigFish\PDF417\Renderers\ImageRenderer;
    include ("letras/NumeroALetras.php");
    include ("config.php");
    
    /******************************************************************************************/
    /* clase PDF
    /******************************************************************************************/
    class PDF extends FPDF{
        
        function Footer(){
            
            $this->SetTextColor(0,0,0);
            $this->SetFont('helvetica','',8);
            $this->SetXY(18,26.2);
            //$this->Cell(0.8, 0.25, utf8_decode("Pág. ").$this->PageNo().' de {nb}', 0, 1,'L', 0);
        }

        function GetMultiCellHeight($w, $h, $txt, $border=null, $align='J') {
            // Calculate MultiCell with automatic or explicit line breaks height
            // $border is un-used, but I kept it in the parameters to keep the call
            //   to this function consistent with MultiCell()
            $cw = &$this->CurrentFont['cw'];
            if($w==0)
                $w = $this->w-$this->rMargin-$this->x;
            $wmax = ($w-2*$this->cMargin)*1000/$this->FontSize;
            $s = str_replace("\r",'',$txt);
            $nb = strlen($s);
            if($nb>0 && $s[$nb-1]=="\n")
                $nb--;
            $sep = -1;
            $i = 0;
            $j = 0;
            $l = 0;
            $ns = 0;
            $height = 0;
            while($i<$nb)
            {
                // Get next character
                $c = $s[$i];
                if($c=="\n")
                {
                    // Explicit line break
                    if($this->ws>0)
                    {
                        $this->ws = 0;
                        $this->_out('0 Tw');
                    }
                    //Increase Height
                    $height += $h;
                    $i++;
                    $sep = -1;
                    $j = $i;
                    $l = 0;
                    $ns = 0;
                    continue;
                }
                if($c==' ')
                {
                    $sep = $i;
                    $ls = $l;
                    $ns++;
                }
                $l += $cw[$c];
                if($l>$wmax)
                {
                    // Automatic line break
                    if($sep==-1)
                    {
                        if($i==$j)
                            $i++;
                        if($this->ws>0)
                        {
                            $this->ws = 0;
                            $this->_out('0 Tw');
                        }
                        //Increase Height
                        $height += $h;
                    }
                    else
                    {
                        if($align=='J')
                        {
                            $this->ws = ($ns>1) ? ($wmax-$ls)/1000*$this->FontSize/($ns-1) : 0;
                            $this->_out(sprintf('%.3F Tw',$this->ws*$this->k));
                        }
                        //Increase Height
                        $height += $h;
                        $i = $sep+1;
                    }
                    $sep = -1;
                    $j = $i;
                    $l = 0;
                    $ns = 0;
                }
                else
                    $i++;
            }
            // Last chunk
            if($this->ws>0)
            {
                $this->ws = 0;
                $this->_out('0 Tw');
            }
            //Increase Height
            $height += $h;

            return $height;
        }
    }

    /******************************************************************************************/
    /* consultas SQL
    /******************************************************************************************/
    

    $id = $_GET['id_proforma'];

    $mysqli = new mysqli($db_host,$db_user,$db_pass,$db_name);

    //Para obtener los datos de la venta
    $query1 = "SELECT * FROM proformas WHERE id_proforma = '".$id."' ";
    $result1 = $mysqli->query($query1);
    $row1 = $result1->fetch_assoc();

    //Para obtener los detalles de la venta
    $query2 = "SELECT * FROM detalle_proforma WHERE id_proforma = '".$id."' ";
    $result2 = $mysqli->query($query2);

    //Para obtener los datos de la empresa
    $query3 = "SELECT * FROM empresa WHERE id_empresa = '1' ";
    $result3 = $mysqli->query($query3);
    $row3 = $result3->fetch_assoc();



    // Variables correspondientes a la factura.
    $RUC        = $row1['numero_documento'];    // RUC.
    $NomRazSoc  = $row1['nombre'];              // Nombre o Razón social.
    $FecEmi     = $row1['fecha_emision'];         // Fecha de emisión.
    $Domicilio  = $row1['direccion'];           // Domicilio.
    //$CodHash    = "";                           // Código Hash.
    //$TipoDoc    = $row1['id_tipo_comprobante']; // Tipo de documento.
    $TotGrav    = 0;                            // Total gravado.
    $TotIGV     = 0;                            // Total IGV.
    $TotMonto   = 0;                            // Total importe. 
    $autoriza   = $row3['autorizacion'];
    $pagina     = $row3['pagina_web'];
    $Saldo      = $row1['saldo'];                               
    $Adelanto   = $row1['adelanto'];  

    /*$xml = file_get_contents('../sunat/xml/comprobantes/'.$row3['ruc'].'-'.$row4['codigo'].'-'.$row1['nombre_comprobante'].'.xml');

    // Obteniendo datos del archivo .XML 
    $DOM = new DOMDocument('1.0', 'ISO-8859-1');
    $DOM->preserveWhiteSpace = FALSE;
    $DOM->loadXML($xml);

   // Obteniendo Codigo Hash
    $DocXML = $DOM->getElementsByTagName('DigestValue');
    $i=0;
    foreach($DocXML as $Nodo){
        if ($i==0){
            $CodHash = $Nodo->nodeValue; 
        }
        $i++;
    } */
   
    // TOTALES DE LA FACTURA 
    
    $sub_total = 0;
    $total = 0;
    $igv = 0;
    $desc = 0;
    $ii=0;
    while($row2 = $result2->fetch_assoc()){

        
        $array['detalle'][$ii]['descripcion'] = $row2['descripcion']; 
        $array['detalle'][$ii]['cantidad'] = number_format($row2['cantidad'] , 2, ".", ""); 
        $array['detalle'][$ii]['precio'] = number_format($row2['precio'], 2, ".", ""); 
        $array['detalle'][$ii]['descuento'] = number_format($row2['descuento'] , 2, ".", ""); 
        $array['detalle'][$ii]['subtotal'] = number_format($row2['subtotal'] , 2, ".", ""); 
        //$sub_total = $sub_total + $row2['precio_venta_neto'];
        //$igv = $igv + $row2['impuesto'];
        $ii++;
    }

    //$TotGrav = number_format($sub_total, 2, '.', '');
    //$TotIGV = number_format($igv, 2, '.', '');
    $TotMonto = number_format($row1['total'], 2, '.', '');       


    // Crear el gráfico con el código de barras
    /*$nom_f = $row1['nombre_comprobante'];
    $tip_f = $row4['nombre'];
    $ruc_e = $row3['ruc'];
    $textoCodBar = "
        | RUC : $ruc_e
        | $tip_f
        | $nom_f
        | SUBTOTAL : $TotGrav
        | IGV : $TotIGV
        | TOTAL : $TotMonto
        | $FecEmi
        | $CodHash
        ";

    $pdf417 = new PDF417();
    $codigo_barra = $pdf417->encode($textoCodBar);
    // Create a PNG image
    $renderer = new ImageRenderer( ['format' => 'png'] );
    $image = $renderer->render($codigo_barra);
    $image->save('image/image_hash.png');*/
 


    /******************************************************************************************/
    /* creamos documento PDF
    /******************************************************************************************/
    

    $pdf=new PDF('P','cm','Letter');
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->AddFont('IDAutomationHC39M','','IDAutomationHC39M.php');
    $pdf->AddFont('helvetica','','helvetica.php');
    $pdf->SetAutoPageBreak(true);
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetLineWidth(0.02);
    $pdf->SetFillColor(0,0,0);

    //DATOS DE EMPRESA
    $pdf->image("../public/img/logo_empresa.jpg",2.1,0.1 , 3.6, 1.8); //ojo
    /*$pdf->SetFont('helvetica','B',12);
    $pdf->SetXY(0, 0.8);
    $pdf->MultiCell(7.6, 0.3, $row3['razon_social'], 0, "C", 0);*/


    $pdf->SetFont('helvetica','',7);
    $pdf->SetXY(0,1.85);
    $pdf->Cell(7.6, 0.25, "RUC: ".$row3['ruc']."   Telf: ".$row3['telefono']."", 0, 1,'C', 0);

    $pdf->SetXY(0, 2.15);
    $pdf->MultiCell(7.6, 0.25, $row3['direccion'], 0, 'C', 0);

    $pdf->SetFont('helvetica','B',9.5);
    $pdf->SetXY(0,2.55);
    $pdf->Cell(7.6, 0.25, utf8_decode("RECIBO N° ").$row1['id_proforma'], 0, 1,'C', 0);

    //DATOS DE FACTURA
    
    $pdf->SetFont('helvetica','B',7);
    $h_titu = $pdf->GetMultiCellHeight(5.1, 0.31, utf8_decode($NomRazSoc) , $border=null, $align='L'); 
    $h_domi = $pdf->GetMultiCellHeight(5.1, 0.31, utf8_decode($Domicilio) , $border=null, $align='L'); 

    $pdf->SetXY(0.2,2.8);
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);



    $pdf->SetXY(0.25,3.2);
    $pdf->Cell(1.2, 0.35, utf8_decode("Cliente               : "), 0, 1,'L', 0);

    $pdf->SetXY(0.2,3.2+$h_titu+$h_domi);
    $pdf->Cell(1, 0.35, utf8_decode("DNI / RUC"), 0, 1,'L', 0);
    


    $pdf->SetXY(0.22,3.2+$h_titu);
    $pdf->Cell(1, 0.35, utf8_decode("Domicilio           : "), 0, 1,'L', 0);

    $pdf->SetXY(0.2,3.55+$h_titu+$h_domi);
    $pdf->Cell(1, 0.35, utf8_decode("Fecha Emision"), 0, 1,'L', 0);

    $pdf->SetXY(0.2,3.91+$h_titu+$h_domi);
    $pdf->Cell(1, 0.35, utf8_decode("Tipo Moneda"), 0, 1,'L', 0);


    $pdf->SetFont('helvetica','',7);

    $pdf->SetXY(2.4,3.2);
    $pdf->MultiCell(5.1, 0.3, $NomRazSoc , 0, "L", 0);

    $pdf->SetXY(2.4,3.2+$h_titu);
    $pdf->MultiCell(5.1, 0.3, $Domicilio , 0, "L", 0);

    $pdf->SetXY(2.1,3.2+$h_titu+$h_domi);
    $pdf->Cell(1, 0.35, ":   ".utf8_decode($RUC), 0, 1,'L', 0);

    $pdf->SetXY(2.1,3.55+$h_titu+$h_domi);
    $pdf->Cell(1, 0.35, ":   ".date_format(date_create($FecEmi), 'd-m-Y'), 0, 1,'L', 0);

    $pdf->SetXY(2.1,3.91+$h_titu+$h_domi);
    $pdf->Cell(1, 0.35, ":   ".utf8_decode("SOL"), 0, 1,'L', 0);

    //DATOS DETALLE FACTURA
    
    $pdf->SetXY(0.2,4.2+$h_titu+$h_domi);
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);

    $Y = $h_titu+$h_domi;

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('helvetica','B',7);

    $pdf->SetXY(0.2,$Y+4.4);
    $pdf->Cell(0.8, 0.5, utf8_decode("Cant."), 0, 1,'C', 0);

    $pdf->SetXY(1.0,$Y+4.4);
    $pdf->Cell(3, 0.5, utf8_decode("Descripción"), 0, 1,'C', 0);

    $pdf->SetXY(4,$Y+4.4);
    $pdf->Cell(1.2, 0.5, utf8_decode("Precio"), 0, 1,'R', 0);

    $pdf->SetXY(5,$Y+4.4);
    $pdf->Cell(1.2, 0.5, utf8_decode("Dscto"), 0, 1,'R', 0);

    $pdf->SetXY(6.2,$Y+4.4);
    $pdf->Cell(1.2, 0.5, utf8_decode("Importe"), 0, 1,'R', 0);

    $pdf->SetXY(0.2,$Y+4.75);
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);

  
    $pdf->SetFont('helvetica','',7);
    $Y=$Y+5.2;
    $Y1 = 0;
    for ($i=0; $i < sizeof($array['detalle']) ; $i++) { 
        

        $h_descrip = $pdf->GetMultiCellHeight(3, 0.35, utf8_decode($array['detalle'][$i]['descripcion']), $border=null, $align='L'); 

        $pdf->SetXY(0.2,$Y+$Y1);
        $pdf->Cell(0.8, 0.35, number_format($array['detalle'][$i]['cantidad'],0), 0, 1,'C', 0);

        $pdf->SetXY(1.0,$Y+$Y1);
        $pdf->MultiCell(3, 0.35, $array['detalle'][$i]['descripcion'] , 0, "L", 0);

        $pdf->SetXY(3.9,$Y+$Y1);
        $pdf->Cell(1.2, 0.35, number_format($array['detalle'][$i]['precio'],2), 0, 1,'R', 0);

        $pdf->SetXY(5.3,$Y+$Y1);
        $pdf->Cell(0.8, 0.35, ($array['detalle'][$i]['descuento']==0 ? number_format($array['detalle'][$i]['descuento'],2) : '-'.number_format($array['detalle'][$i]['descuento'],2) ), 0, 1,'R', 0);

        $pdf->SetXY(6,$Y+$Y1);
        $pdf->Cell(1.4, 0.35, number_format($array['detalle'][$i]['subtotal'],2), 0, 1,'R', 0);

        $Y1 = $Y1 + $h_descrip;
    } 

    //TOTALES FACTURA
    
    $pdf->SetFont('helvetica','',7);

    $Y2 = $Y1 + $Y + 0.15;

    $pdf->line(0.25, $Y2+0.2, 7.35, $Y2+0.2);
/*
    $pdf->SetXY(0.2,$Y2+0.4);
    $pdf->Cell(6, 0.35, utf8_decode("Valor de Venta - Operaciones Gravadas          S/ "), 0, 1,'R', 0);

    $pdf->SetXY(0.2,$Y2+0.8);
    $pdf->Cell(6, 0.35, utf8_decode("IGV          S/ "), 0, 1,'R', 0);*/



    $pdf->SetFont('helvetica','B',9);
    $pdf->SetXY(0.2,$Y2+0.4);
    $pdf->Cell(5.8, 0.35, utf8_decode("Importe Total         "), 0, 1,'R', 0);

    $pdf->SetFont('helvetica','B',8);
    $pdf->SetXY(0.2, $Y2+1);
    $pdf->Cell(6, 0.35, utf8_decode("A Cuenta         S/ "), 0, 1,'R', 0);

    $pdf->SetXY(0.2, $Y2+1.5);
    $pdf->Cell(6, 0.35, utf8_decode("Saldo          S/ "), 0, 1,'R', 0);

    $pdf->SetFont('helvetica','B',9);

    $pdf->SetXY(6.2,$Y2+0.4);
    $pdf->Cell(1.2, 0.35, "S/ ".number_format($TotMonto,2), 0, 1,'R', 0);


    $pdf->SetFont('helvetica','B',8);
    $pdf->SetXY(6.2, $Y2+1);
    $pdf->Cell(1.2, 0.35, number_format($Adelanto,2), 0, 1,'R', 0);


    $pdf->SetXY(6.2, $Y2+1.5);
    $pdf->Cell(1.2, 0.35, number_format($Saldo,2), 0, 1,'R', 0);

    $pdf->line(0.25, $Y2+2, 7.35, $Y2+2);

    $Y2 = $Y2 + 1;



/*    $pdf->SetFont('helvetica','',7);
    $pdf->SetXY(6.2,$Y2+0.4);
    $pdf->Cell(1.2, 0.35, number_format($TotGrav,2), 0, 1,'R', 0);

    $pdf->SetXY(6.2,$Y2+0.8);
    $pdf->Cell(1.2, 0.35, number_format($TotIGV,2), 0, 1,'R', 0);*/

    

    //$pdf->line(0.25, $Y2+1.2, 7.35, $Y2+1.2);

    //Monto en LETRAS
    $letras = NumeroALetras::convertir($TotMonto, 'soles', 'centimos');
    $pdf->SetFont('helvetica','BI',6.5);
    $pdf->SetXY(0.15,$Y2+1.5);
    $pdf->MultiCell(7, 0.35,"SON : ".$letras , 0, 'L');


    //PIE DE PAGINA
    
    //$pdf->image('image/image_hash.png',0.8,$Y2+ 2.2, 6, 2); 

    //$pdf->line(0.25, $Y2+3, 7.35, $Y2+3);
    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('helvetica','BI',6.5);
    $pdf->SetXY(0.1,$Y2+3.1);
    $pdf->MultiCell(7.5, 0.35, utf8_decode("Comprobante NO VALIDO, reclame su BOLETA o FACTURA \n $pagina \n GRACIAS POR SU PREFERENCIA !!"), 0, 'C'); 

    //==============================================================================
    
    
    $NomArchPDF = "ticketProforma.pdf";    
    $pdf->Output($NomArchPDF, 'F'); // Se graba el documento .PDF en el disco duro o unidad de estado sólido.
    chmod ($NomArchPDF,0777);  // Se dan permisos de lectura y escritura.
    $pdf->Output($NomArchPDF, 'I'); // Se muestra el documento .PDF en el navegador.    
    
    //unlink('image/image_hash.png');
ob_end_flush(); 