<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	$consulta = 'SELECT v.nombre_comprobante as comprobante , g.* , g.estado as est, c.nombre as nombre, c.numero_documento as numero FROM guia_remision g INNER JOIN ventas v ON g.id_venta = v.id_venta INNER JOIN clientes c ON c.id_cliente = v.id_cliente ORDER BY g.numero_guia ASC';

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de GUIA DE REMISION")
									 ->setSubject("Reporte de GUIA DE REMISION")
									 ->setDescription("Reporte de GUIA DE REMISION")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE GUIA DE REMISION EMITIDOS')
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'CLIENTE')
		            ->setCellValue('C2', 'DNI / RUC DE CLIENTE')
					->setCellValue('D2', 'N°  BOLETA / FACTURA')
					->setCellValue('E2', 'FECHA DE TRASLADO')
					->setCellValue('F2', 'N° GUIA REMISION')
					->setCellValue('G2', 'DIRECCION DE PARTIDA')
					->setCellValue('H2', 'DIRECCION DE LLEGADA')
					->setCellValue('I2', 'NOMBRE DEL TRANSPORTISTA')
					->setCellValue('J2', 'DNI / RUC DE TRANSPORTISTA')
					->setCellValue('K2', 'N° LICENCIA DE CONDUCIR')
					->setCellValue('L2', 'MARCA / PLACA DE VEHICULO')
					->setCellValue('M2', 'ESTADO');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:M2')->applyFromArray($boldArray);

		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(80);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(35);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$j = 1;

		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, $fila['numero'])
			    ->setCellValue('D'.$i, utf8_encode($fila['comprobante']))
			    ->setCellValue('E'.$i, $fila['fecha_traslado'])
			    ->setCellValue('F'.$i, $fila['nombre_guia'])
			    ->setCellValue('G'.$i, utf8_encode($fila['punto_partida']))
			    ->setCellValue('H'.$i, utf8_encode($fila['punto_llegada']))
			    ->setCellValue('I'.$i, utf8_encode($fila['nombre_transportista']))
			    ->setCellValue('J'.$i, utf8_encode($fila['documento_transportista']))
			    ->setCellValue('K'.$i, utf8_encode($fila['licencia']))
			    ->setCellValue('L'.$i, utf8_encode($fila['marca_placa']))
			    ->setCellValue('M'.$i, $fila['est'] == 0 ? 'ANULADO' : 'OK');
			$i++;
			$j++;
			//$suma = $suma+$fila['Monto S/'];
		}

		/*$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('F3:F'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');*/

		$i = $i-1;
		$H = "M".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Guia de Remision');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_guia_remision.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






