<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	$consulta = 'SELECT * FROM huespedes WHERE estado = 1 ORDER BY nombre ASC';

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de HUESPEDES")
									 ->setSubject("Reporte de HUESPEDES")
									 ->setDescription("Reporte de HUESPEDES")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE HUESPEDES REGISTRADOS')
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'NOMBRE')
		            ->setCellValue('C2', 'N° DOCUMENTO')
					->setCellValue('D2', 'GENERO')
					->setCellValue('E2', 'OCUPACION')
					->setCellValue('F2', 'F. NACIMIENTO')
					->setCellValue('G2', 'TELEFONO')
					->setCellValue('H2', 'EMAIL')
					->setCellValue('I2', 'PAIS')
					->setCellValue('J2', 'CIUDAD')
					->setCellValue('K2', 'RAZON SOCIAL')
					->setCellValue('L2', 'RUC')
					->setCellValue('M2', 'DIRECCION');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:M2')->applyFromArray($boldArray);

		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(100);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(80);

	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		//$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, utf8_encode($fila['dni']))
			    ->setCellValue('D'.$i, utf8_encode($fila['genero']))
			    ->setCellValue('E'.$i, utf8_encode($fila['ocupacion']))
			    ->setCellValue('F'.$i, utf8_encode($fila['fecha_nacimiento']))
			    ->setCellValue('G'.$i, utf8_encode($fila['telefono']))
			    ->setCellValue('H'.$i, utf8_encode($fila['email']))
			    ->setCellValue('I'.$i, utf8_encode($fila['pais']))
			    ->setCellValue('J'.$i, utf8_encode($fila['ciudad']))
			    ->setCellValue('K'.$i, utf8_encode($fila['razon_social']))
			    ->setCellValue('L'.$i, utf8_encode($fila['ruc']))
			    ->setCellValue('M'.$i, utf8_encode($fila['direccion_empresa']));
			$i++;
			$j++;
			//$suma = $suma+$fila['Monto S/'];
		}

		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
		//$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);
		//$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		//$objPHPExcel->getActiveSheet()->getStyle('F3:F'.$i)->getNumberFormat()->setFormatCode('0.00');
		//$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		//$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "M".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Huespedes');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_huespedes.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






