<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$opcion = $_GET['tipo_comprobante'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($opcion == "1") { //OPCION FACTURA
		
		$consulta = 'SELECT @rownum := @rownum +1 AS Item , c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT(fecha_venta, "%d-%m-%Y" ) AS "Fecha de Emision", serie_comprobante AS "SERIE", numero_comprobante AS "NUMERO", total_venta AS "Monto S/", estado_envio AS "ESTADO" , mensaje_envio AS "MENSAJE" , id_nota FROM (SELECT @rownum :=0) AS ROW , ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente WHERE (fecha_venta >= "'.$fecha1.'" AND fecha_venta <= "'.$fecha2.'") AND id_tipo_comprobante="1" AND id_local= "'.$id_local.'" AND contingencia = "0" ORDER BY numero_comprobante ASC';
	
		 
		$resultado = $conexion->query($consulta);

		if($resultado->num_rows > 0 ){

			// Propiedades del documento
			$objPHPExcel->getProperties()->setCreator("Seven")
										 ->setLastModifiedBy("Seven")
										 ->setTitle("Reporte de FACTURAS ELECTRONICAS")
										 ->setSubject("Reporte de FACTURAS ELECTRONICAS")
										 ->setDescription("Reporte de FACTURAS ELECTRONICAS")
										 ->setKeywords("office 2010 openxml php")
										 ->setCategory("Archivo con resultado de reporte");
			
			// Combino las celdas desde A1 hasta F1
			$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
			$objPHPExcel->setActiveSheetIndex(0)
			            ->setCellValue('A1', 'REPORTE DE FACTURAS ELECTRONICAS EMITIDAS ENTRE : '.$fecha1.' & '.$fecha2)
			            ->setCellValue('A2', 'ITEM')
			            ->setCellValue('B2', 'RAZON SOCIAL')
			            ->setCellValue('C2', 'RUC')
						->setCellValue('D2', 'FECHA EMISION')
						->setCellValue('E2', 'SERIE')
						->setCellValue('F2', 'NUMERO')
						->setCellValue('G2', 'MONTO S/')
						->setCellValue('H2', 'TIENE NOTA?')
						->setCellValue('I2', 'ENVIO SUNAT')
						->setCellValue('J2', 'MENSAJE DE SUNAT');
						
			// Fuente de la primera fila en negrita
			$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
			$objPHPExcel->getActiveSheet()->getStyle('A1:J2')->applyFromArray($boldArray);


			//Ancho de las columnas
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(200);
		
			$i = 3; //Numero de fila donde se va a comenzar a rellenar
			$suma = 0;
			while ($fila = $resultado->fetch_array()) {
				$objPHPExcel->setActiveSheetIndex(0)
				    ->setCellValue('A'.$i, $fila['Item'])
				    ->setCellValue('B'.$i, utf8_encode($fila['Titular']))
				    ->setCellValue('C'.$i, $fila['NUM'])
				    ->setCellValue('D'.$i, $fila['Fecha de Emision'])
				    ->setCellValue('E'.$i, $fila['SERIE'])
				    ->setCellValue('F'.$i, $fila['NUMERO'])
				    ->setCellValue('G'.$i, $fila['Monto S/'])
				    ->setCellValue('H'.$i, $fila['id_nota'] != null ? 'SI' : '')
				    ->setCellValue('I'.$i, $fila['ESTADO'])
				    ->setCellValue('J'.$i, utf8_encode($fila['MENSAJE']));
				$i++;
				$suma = $suma+$fila['Monto S/'];
			}

			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
			$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');

			$i = $i-1;
			$H = "J".$i;
			$rango = "A2:$H";
			$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
			'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
			);
			$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

			// Cambiar el nombre de hoja de cálculo
			$objPHPExcel->getActiveSheet()->setTitle('Reporte de Facturas');

			// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
			$objPHPExcel->setActiveSheetIndex(0);

			// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="Reporte_Facturas.xlsx"');
			header('Cache-Control: max-age=0');
			 
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			$objWriter->save('php://output');
			exit;

		}
		else{
		    print_r('No hay resultados para mostrar');
		}

	} 

	if ($opcion == "2") { //OPCION BOLETA

	    $consulta = 'SELECT @rownum := @rownum +1 AS Item , c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT(fecha_venta, "%d-%m-%Y" ) AS "Fecha de Emision", serie_comprobante AS "SERIE", numero_comprobante AS "NUMERO", total_venta AS "Monto S/", estado_envio AS "ESTADO", id_nota FROM (SELECT @rownum :=0) AS ROW , ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente WHERE (fecha_venta >= "'.$fecha1.'" AND fecha_venta <= "'.$fecha2.'") AND id_tipo_comprobante="2" AND id_local= "'.$id_local.'" AND contingencia = "0" ORDER BY numero_comprobante ASC';
		 
		$resultado = $conexion->query($consulta);

		if($resultado->num_rows > 0 ){

			// Propiedades del documento
			$objPHPExcel->getProperties()->setCreator("Seven")
										 ->setLastModifiedBy("Seven")
										 ->setTitle("Reporte de BOLETAS ELECTRONICAS")
										 ->setSubject("Reporte de BOLETAS ELECTRONICAS")
										 ->setDescription("Reporte de BOLETAS ELECTRONICAS")
										 ->setKeywords("office 2010 openxml php")
										 ->setCategory("Archivo con resultado de reporte");
			
			// Combino las celdas desde A1 hasta F1
			$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
			$objPHPExcel->setActiveSheetIndex(0)
			            ->setCellValue('A1', 'REPORTE DE BOLETAS ELECTRONICAS EMITIDAS ENTRE : '.$fecha1.' & '.$fecha2)
			            ->setCellValue('A2', 'ITEM')
			            ->setCellValue('B2', 'CLIENTE')
			            ->setCellValue('C2', 'DNI')
						->setCellValue('D2', 'FECHA EMISION')
						->setCellValue('E2', 'SERIE')
						->setCellValue('F2', 'NUMERO')
						->setCellValue('G2', 'MONTO S/')
						->setCellValue('H2', 'ENVIO SUNAT')
						->setCellValue('I2', 'TIENE NOTA?');
						
			// Fuente de la primera fila en negrita
			$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
			$objPHPExcel->getActiveSheet()->getStyle('A1:I2')->applyFromArray($boldArray);


			//Ancho de las columnas
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
		
			$i = 3; //Numero de fila donde se va a comenzar a rellenar
			$suma = 0;
			while ($fila = $resultado->fetch_array()) {
				$objPHPExcel->setActiveSheetIndex(0)
				    ->setCellValue('A'.$i, $fila['Item'])
				    ->setCellValue('B'.$i, utf8_encode($fila['Titular']))
				    ->setCellValue('C'.$i, $fila['NUM'])
				    ->setCellValue('D'.$i, $fila['Fecha de Emision'])
				    ->setCellValue('E'.$i, $fila['SERIE'])
				    ->setCellValue('F'.$i, $fila['NUMERO'])
				    ->setCellValue('G'.$i, $fila['Monto S/'])
				    ->setCellValue('H'.$i, $fila['ESTADO'])
				    ->setCellValue('I'.$i, $fila['id_nota'] != null ? 'SI' : '');
				$i++;
				$suma = $suma+$fila['Monto S/'];
			}

			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
			$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');

			$i=$i-1;
			$H = "I".$i;
			$rango="A2:$H";
			$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
			'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
			);
			$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);
			
			// Cambiar el nombre de hoja de cálculo
			$objPHPExcel->getActiveSheet()->setTitle('Reporte de Boletas');

			// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
			$objPHPExcel->setActiveSheetIndex(0);

			// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="Reporte_Boletas.xlsx"');
			header('Cache-Control: max-age=0');
			 
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			$objWriter->save('php://output');
			exit;

		}
		else{
		    print_r('No hay resultados para mostrar');
		}

	} 
	if ($opcion == "3") { //OPCION NOTA CREDITO
		
		$consulta = 'SELECT @rownum := @rownum +1 AS Item , c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT( n.fecha_emision, "%d-%m-%Y" ) AS "Fecha de Emision", serie_nota AS "SERIE", numero_nota AS "NUMERO", v.nombre_comprobante AS "Comprobante Afectado", motivo AS Motivo, n.descripcion AS "Detalle", v.total_venta AS "Monto S/", n.estado_envio AS "Estado" FROM (SELECT @rownum :=0) AS ROW , notas n INNER JOIN ventas v ON n.id_venta = v.id_venta INNER JOIN clientes c ON c.id_cliente = v.id_cliente WHERE (n.fecha_emision >= "'.$fecha1.'" AND n.fecha_emision <= "'.$fecha2.'") AND n.id_tipo_comprobante="3" AND n.id_local= "'.$id_local.'" AND n.contingencia = "0" ORDER BY numero_nota ASC';
		 
		$resultado = $conexion->query($consulta);

		if($resultado->num_rows > 0 ){

			// Propiedades del documento
			$objPHPExcel->getProperties()->setCreator("Seven")
										 ->setLastModifiedBy("Seven")
										 ->setTitle("Reporte de NOTAS ELECTRONICAS")
										 ->setSubject("Reporte de NOTAS ELECTRONICAS")
										 ->setDescription("Reporte de NOTAS ELECTRONICAS")
										 ->setKeywords("office 2010 openxml php")
										 ->setCategory("Archivo con resultado de reporte");
			
			// Combino las celdas desde A1 hasta F1
			$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
			$objPHPExcel->setActiveSheetIndex(0)
			            ->setCellValue('A1', 'REPORTE DE NOTAS DE CREDITO EMITIDAS ENTRE : '.$fecha1.' & '.$fecha2)
			            ->setCellValue('A2', 'ITEM')
			            ->setCellValue('B2', 'CLIENTE')
			            ->setCellValue('C2', 'RUC / DNI')
						->setCellValue('D2', 'FECHA EMISION')
						->setCellValue('E2', 'SERIE')
						->setCellValue('F2', 'NUMERO')
						->setCellValue('G2', 'MOTIVO')
						->setCellValue('H2', 'DETALLE')
						->setCellValue('I2', 'COMPROBANTE AFECTADO')
						->setCellValue('J2', 'MONTO S/')
						->setCellValue('K2', 'ENVIO SUNAT');
						
			// Fuente de la primera fila en negrita
			$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
			$objPHPExcel->getActiveSheet()->getStyle('A1:K2')->applyFromArray($boldArray);


			//Ancho de las columnas
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(50);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(30);
		
			$i = 3; //Numero de fila donde se va a comenzar a rellenar
			$suma = 0;
			while ($fila = $resultado->fetch_array()) {
				$objPHPExcel->setActiveSheetIndex(0)
				    ->setCellValue('A'.$i, $fila['Item'])
				    ->setCellValue('B'.$i, utf8_encode($fila['Titular']))
				    ->setCellValue('C'.$i, $fila['NUM'])
				    ->setCellValue('D'.$i, $fila['Fecha de Emision'])
				    ->setCellValue('E'.$i, $fila['SERIE'])
				    ->setCellValue('F'.$i, $fila['NUMERO'])
				    ->setCellValue('G'.$i, utf8_encode($fila['Motivo']))
				    ->setCellValue('H'.$i, utf8_encode($fila['Detalle']))
				    ->setCellValue('I'.$i, $fila['Comprobante Afectado'])
				    ->setCellValue('J'.$i, $fila['Monto S/'])
				    ->setCellValue('K'.$i, $fila['Estado']);
				$i++;
				$suma = $suma+$fila['Monto S/'];
			}

			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I'.$i, "TOTAL");
			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('J'.$i, $suma);
			$objPHPExcel->getActiveSheet()->getStyle('I'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('J'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->getNumberFormat()->setFormatCode('0.00');

			$i=$i-1;
			$J = "K".$i;
			$rango="A2:$J";
			$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
			'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
			);
			$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

			// Cambiar el nombre de hoja de cálculo
			$objPHPExcel->getActiveSheet()->setTitle('Reporte de Nota de Credito');

			// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
			$objPHPExcel->setActiveSheetIndex(0);

			// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="Reporte_Nota_Credito.xlsx"');
			header('Cache-Control: max-age=0');
			 
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			$objWriter->save('php://output');
			exit;

		}
		else{
		    print_r('No hay resultados para mostrar');
		}

	} 
	if ($opcion == "4") { //OPCION NOTA DEBITO
		

		$consulta = 'SELECT @rownum := @rownum +1 AS Item , c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT( n.fecha_emision, "%d-%m-%Y" ) AS "Fecha de Emision", serie_nota AS "SERIE", numero_nota AS "NUMERO", v.nombre_comprobante AS "Comprobante Afectado", motivo AS Motivo, n.descripcion AS "Detalle", v.total_venta AS "Monto S/", n.estado_envio AS "Estado" FROM (SELECT @rownum :=0) AS ROW , notas n INNER JOIN ventas v ON n.id_venta = v.id_venta INNER JOIN clientes c ON c.id_cliente = v.id_cliente WHERE (n.fecha_emision >= "'.$fecha1.'" AND n.fecha_emision <= "'.$fecha2.'") AND n.id_tipo_comprobante="4" AND n.id_local= "'.$id_local.'" AND n.contingencia = "0" ORDER BY numero_nota ASC';
		 
		$resultado = $conexion->query($consulta);

		if($resultado->num_rows > 0 ){

			// Propiedades del documento
			$objPHPExcel->getProperties()->setCreator("Seven")
										 ->setLastModifiedBy("Seven")
										 ->setTitle("Reporte de NOTAS ELECTRONICAS")
										 ->setSubject("Reporte de NOTAS ELECTRONICAS")
										 ->setDescription("Reporte de NOTAS ELECTRONICAS")
										 ->setKeywords("office 2010 openxml php")
										 ->setCategory("Archivo con resultado de reporte");
			
			// Combino las celdas desde A1 hasta F1
			$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
			$objPHPExcel->setActiveSheetIndex(0)
			            ->setCellValue('A1', 'REPORTE DE NOTAS DE DEBITO EMITIDAS ENTRE : '.$fecha1.' & '.$fecha2)
			            ->setCellValue('A2', 'ITEM')
			            ->setCellValue('B2', 'CLIENTE')
			            ->setCellValue('C2', 'RUC/DNI')
						->setCellValue('D2', 'FECHA EMISION')
						->setCellValue('E2', 'SERIE')
						->setCellValue('F2', 'NUMERO')
						->setCellValue('G2', 'MOTIVO')
						->setCellValue('H2', 'DETALLE')
						->setCellValue('I2', 'COMPROBANTE AFECTADO')
						->setCellValue('J2', 'MONTO S/')
						->setCellValue('K2', 'ENVIO SUNAT');
						
			// Fuente de la primera fila en negrita
			$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
			$objPHPExcel->getActiveSheet()->getStyle('A1:K2')->applyFromArray($boldArray);


			//Ancho de las columnas
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(50);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(50);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(30);
		
			$i = 3; //Numero de fila donde se va a comenzar a rellenar
			$suma = 0;
			while ($fila = $resultado->fetch_array()) {
				$objPHPExcel->setActiveSheetIndex(0)
				    ->setCellValue('A'.$i, $fila['Item'])
				    ->setCellValue('B'.$i, utf8_encode($fila['Titular']))
				    ->setCellValue('C'.$i, $fila['NUM'])
				    ->setCellValue('D'.$i, $fila['Fecha de Emision'])
				    ->setCellValue('E'.$i, $fila['SERIE'])
				    ->setCellValue('F'.$i, $fila['NUMERO'])
				    ->setCellValue('G'.$i, utf8_encode($fila['Motivo']))
				    ->setCellValue('H'.$i, utf8_encode($fila['Detalle']))
				    ->setCellValue('I'.$i, $fila['Comprobante Afectado'])
				    ->setCellValue('J'.$i, $fila['Monto S/'])
				    ->setCellValue('K'.$i, $fila['Estado']);
				$i++;
				$suma = $suma+$fila['Monto S/'];
			}

			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I'.$i, "TOTAL");
			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('J'.$i, $suma);
			$objPHPExcel->getActiveSheet()->getStyle('I'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('J'.$i)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->getNumberFormat()->setFormatCode('0.00');

			$i=$i-1;
			$J = "K".$i;
			$rango="A2:$J";
			$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
			'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
			);
			$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);


			// Cambiar el nombre de hoja de cálculo
			$objPHPExcel->getActiveSheet()->setTitle('Reporte de Nota de Debito');

			// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
			$objPHPExcel->setActiveSheetIndex(0);

			// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="Reporte_Nota_Debito.xlsx"');
			header('Cache-Control: max-age=0');
			 
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			$objWriter->save('php://output');
			exit;

		}
		else{
		    print_r('No hay resultados para mostrar');
		}

	} 






