<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}


	$consulta = 'SELECT g.* , g.estado as est, c.nombre as cliente, c.numero_documento as documento FROM guia_remision g INNER JOIN ventas v ON g.id_venta = v.id_venta INNER JOIN clientes c ON v.id_cliente = c.id_cliente  WHERE (g.created_at >= "'.$fecha1.' 00:00:00" AND g.created_at <= "'.$fecha2.' 23:59:59") ORDER BY numero_guia ASC';

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de GUIAS DE REMISION")
									 ->setSubject("Reporte de GUIAS DE REMISION")
									 ->setDescription("Reporte de GUIAS DE REMISION")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE GUIAS DE REMISION EMITIDOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'NOMBRE DEL CLIENTE')
		            ->setCellValue('C2', 'DNI/RUC CLIENTE')
					->setCellValue('D2', 'N° GUIA REMISION')
					->setCellValue('E2', 'FECHA DE TRASLADO')
					->setCellValue('F2', 'PUNTO DE PARTIDA')
					->setCellValue('G2', 'PUNTO DE LLEGADA')
					->setCellValue('H2', 'NOMBRE DEL TRANSPORTISTA')
					->setCellValue('I2', 'DNI/RUC TRANS.')
					->setCellValue('J2', 'LICENCIA DE CONDUCIR')
					->setCellValue('K2', 'MARCA / PLACA DEL VEHICULO')
					->setCellValue('L2', 'ESTADO');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:L2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(60);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		//$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['cliente']))
			    ->setCellValue('C'.$i, $fila['documento'])
			    ->setCellValue('D'.$i, $fila['nombre_guia'])
			    ->setCellValue('E'.$i, $fila['fecha_traslado'])
			    ->setCellValue('F'.$i, utf8_encode($fila['punto_partida']))
			    ->setCellValue('G'.$i, utf8_encode($fila['punto_llegada']))
			    ->setCellValue('H'.$i, utf8_encode($fila['nombre_transportista']))
			    ->setCellValue('I'.$i, $fila['documento_transportista'])
			    ->setCellValue('J'.$i, utf8_encode($fila['licencia']))
			    ->setCellValue('K'.$i, utf8_encode($fila['marca_placa']))
			    ->setCellValue('L'.$i, $fila['est']==0 ? 'ANULADO' : 'OK');
			$i++;
			$j++;
			//$suma = $suma+$fila['total'];
		}

		/*$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('E3:E'.$i)->getNumberFormat()->setFormatCode('0.00');*/

		$i = $i-1;
		$H = "L".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Guias de Remision');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_guia_remision.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






