<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($id_local == 0) {
		$consulta = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.precio, SUM(d.cantidad) as cantidad , SUM(d.precio_compra_total) as total FROM detalle_compra d INNER JOIN productos p ON p.id_producto = d.id_producto INNER JOIN compras c ON c.id_compra = d.id_compra INNER JOIN local l ON c.id_local = l.id_local WHERE (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") GROUP BY d.id_producto';
	} else{
		$consulta = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.precio, SUM(d.cantidad) as cantidad , SUM(d.precio_compra_total) as total FROM detalle_compra d INNER JOIN productos p ON p.id_producto = d.id_producto INNER JOIN compras c ON c.id_compra = d.id_compra INNER JOIN local l ON c.id_local = l.id_local WHERE (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") AND c.id_local="'.$id_local.'" GROUP BY d.id_producto';
	}

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS COMPRADOS")
									 ->setSubject("Reporte de PRODUCTOS COMPRADOS")
									 ->setDescription("Reporte de PRODUCTOS COMPRADOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS COMPRADOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'PRODUCTO')
		            ->setCellValue('C2', 'CODIGO BARRAS')
					->setCellValue('D2', 'MARCA')
					->setCellValue('E2', 'PRECIO DE VENTA UNITARIO S/')
					->setCellValue('F2', 'CANTIDAD COMPRADA')
					->setCellValue('G2', 'INVERSION S/');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:G2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, $fila['codigo_barras'])
			    ->setCellValue('D'.$i, utf8_encode($fila['descripcion']))
			    ->setCellValue('E'.$i, $fila['precio'])
			    ->setCellValue('F'.$i, $fila['cantidad'])
			    ->setCellValue('G'.$i, $fila['total']);
			$i++;
			$j++;
			$suma = $suma+$fila['total'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('E3:E'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "G".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos Comprados');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Productos_Comprados.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






