<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}


	$consulta = 'SELECT p.observacion, d.descripcion, p.fecha_emision, d.precio, d.descuento, d.cantidad , d.subtotal as total, CONCAT("RECIBO N° ", p.id_proforma) as nombre_comprobante, p.nombre as c_nombre, p.numero_documento as c_documento , u.nombres as nom_personal, u.apellidos as ap_personal FROM detalle_proforma d INNER JOIN proformas p ON p.id_proforma = d.id_proforma INNER JOIN usuarios u ON u.id_usuario = p.id_usuario WHERE (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") AND p.estado="1" ORDER BY p.id_proforma'; 


	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS VENDIDOS")
									 ->setSubject("Reporte de PRODUCTOS VENDIDOS")
									 ->setDescription("Reporte de PRODUCTOS VENDIDOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS VENDIDOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'CONCEPTO')
					->setCellValue('C2', 'CANTIDAD')
					->setCellValue('D2', 'PRECIO UNITARIO S/')
					->setCellValue('E2', 'DESCUENTO S/')
					->setCellValue('F2', 'TOTAL S/')
					->setCellValue('G2', 'N° COMPROBANTE')
					->setCellValue('H2', 'NOMBRE DE CLIENTE')
					->setCellValue('I2', 'N° DOCUMENTO')
					->setCellValue('J2', 'PERSONAL QUE REGISTRO LA VENTA')
					->setCellValue('K2', 'FECHA DE EMISION')
					->setCellValue('L2', 'OBSERVACION');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:L2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(150);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(80);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['descripcion']))
			    ->setCellValue('C'.$i, $fila['cantidad'])
			    ->setCellValue('D'.$i, $fila['precio'])
			    ->setCellValue('E'.$i, $fila['descuento'])
			    ->setCellValue('F'.$i, $fila['total'])
			    ->setCellValue('G'.$i, $fila['nombre_comprobante'])
			    ->setCellValue('H'.$i, utf8_encode($fila['c_nombre']))
			    ->setCellValue('I'.$i, $fila['c_documento'])
			    ->setCellValue('J'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
			    ->setCellValue('K'.$i, $fila['fecha_emision'])
			    ->setCellValue('L'.$i, utf8_encode($fila['observacion']));
			$i++;
			$j++;
			$suma = $suma+$fila['total'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('E'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('E'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('D3:D'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('E3:E'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('F3:F'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "L".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos Vendidos');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Productos_Vendidos.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






