<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_usuario = $_GET['id_usuario'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($id_usuario == 0) {
		$consulta = 'SELECT l.nombre as local, u.nombres AS "nombres", u.apellidos AS "apellidos", c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT(v.created_at, "%d-%m-%Y %h:%i:%s") AS "Fecha de Venta", nombre_comprobante, total_venta AS "Monto S/" FROM ventas v INNER JOIN usuarios u ON v.id_usuario = u.id_usuario INNER JOIN clientes c ON v.id_cliente = c.id_cliente INNER JOIN local l ON l.id_local = v.id_local WHERE (v.created_at >= "'.$fecha1.'" AND v.created_at <= "'.$fecha2.'") ORDER BY v.created_at ASC';
	}
	else{
		$consulta = 'SELECT l.nombre as local, u.nombres AS "nombres", u.apellidos AS "apellidos", c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT(v.created_at, "%d-%m-%Y %h:%i:%s") AS "Fecha de Venta", nombre_comprobante, total_venta AS "Monto S/" FROM ventas v INNER JOIN usuarios u ON v.id_usuario = u.id_usuario INNER JOIN clientes c ON v.id_cliente = c.id_cliente INNER JOIN local l ON l.id_local = v.id_local WHERE (v.created_at >= "'.$fecha1.'" AND v.created_at <= "'.$fecha2.'") AND v.id_usuario= "'.$id_usuario.'" ORDER BY v.created_at ASC';
	}
	

	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de VENTAS POR PERSONAL")
									 ->setSubject("Reporte de VENTAS POR PERSONAL")
									 ->setDescription("Reporte de VENTAS POR PERSONAL")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE VENTAS POR PERSONAL ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'LOCAL')
		            ->setCellValue('C2', 'PERSONAL')
		            ->setCellValue('D2', 'CLIENTE')
		            ->setCellValue('E2', 'RUC / DNI')
					->setCellValue('F2', 'FECHA DE VENTA')
					->setCellValue('G2', 'COMPROBANTE')
					->setCellValue('H2', 'MONTO S/');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:H2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(60);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['local']))
			    ->setCellValue('C'.$i, utf8_encode($fila['nombres'] .' '. $fila['apellidos']))
			    ->setCellValue('D'.$i, utf8_encode($fila['Titular']))
			    ->setCellValue('E'.$i, $fila['NUM'])
			    ->setCellValue('F'.$i, $fila['Fecha de Venta'])
			    ->setCellValue('G'.$i, $fila['nombre_comprobante'])
			    ->setCellValue('H'.$i, $fila['Monto S/']);
			$i++;
			$j++;
			$suma = $suma+$fila['Monto S/'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('H'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "H".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Compras');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Personal.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






