<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	$consulta = 'SELECT c.nombre AS "Titular", c.numero_documento AS "NUM", DATE_FORMAT(fecha_venta, "%d-%m-%Y" ) AS "Fecha de Emision", nombre_comprobante AS "Comprobante", t.nombre AS "Tipo", total_venta AS "Monto S/", tipo_pago FROM ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente INNER JOIN tipo_comprobante t ON v.id_tipo_comprobante = t.id_tipo_comprobante WHERE (fecha_venta >= "'.$fecha1.'" AND fecha_venta <= "'.$fecha2.'") AND id_local= "'.$id_local.'" ORDER BY fecha_venta ASC';

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de INGRESOS")
									 ->setSubject("Reporte de INGRESOS")
									 ->setDescription("Reporte de INGRESOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE INGRESOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'CLIENTE')
		            ->setCellValue('C2', 'RUC / DNI')
					->setCellValue('D2', 'FECHA DE VENTA')
					->setCellValue('E2', 'COMPROBANTE')
					->setCellValue('F2', 'TIPO')
					->setCellValue('G2', 'MODO DE PAGO')
					->setCellValue('H2', 'MONTO S/');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:H2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['Titular']))
			    ->setCellValue('C'.$i, $fila['NUM'])
			    ->setCellValue('D'.$i, $fila['Fecha de Emision'])
			    ->setCellValue('E'.$i, $fila['Comprobante'])
			    ->setCellValue('F'.$i, $fila['Tipo'])
			    ->setCellValue('G'.$i, utf8_encode($fila['tipo_pago']))
			    ->setCellValue('H'.$i, $fila['Monto S/']);
			$i++;
			$j++;
			$suma = $suma+$fila['Monto S/'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('H'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "H".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Ingresos');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Ingresos.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






