$(function () {

    $('#frmEditar').form({
    	keyboardShortcuts: false,
    	fields: {
	      	razon_social: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    ruc: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type : 'integer', prompt : 'Ingrese solo números'},
			        { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    },
		    representante: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    direccion: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    dni: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type : 'integer', prompt : 'Ingrese solo números'},
			        { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
		        ]
		    },
		    autorizacion: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    email: {
		        rules: [
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'email', prompt : 'Ingrese un email valido'}
		        ]
		    },
		    telefono: {
		        rules: [
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'}
		        ]
		    },
		    pagina_web: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    ubigeo: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    valor_impuesto: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
    	},
    	inline : true,
  
    });

	$('.btn_guardar').on('click', function() {
		if ($('#frmEditar').form('is valid')) {
			$('#update_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmEditar').form('validate form');
		}
  	});
  	
	function sendForm() {

	    var data = $('#frmEditar').serialize();

        $.requestApi('/empresa/actualizar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
