$(function () {

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
	      	razon_social: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    ruc: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type : 'integer', prompt : 'Ingrese solo números'},
			        { type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    },
		    representante: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    direccion: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    dni: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type : 'integer', prompt : 'Ingrese solo números'},
			        { type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
		        ]
		    },
		    autorizacion: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    email: {
		    	optional: true,
		        rules: [{ type : 'email', prompt : 'Ingrese un email valido'}]
		    },
		    telefono: {
		    	optional: true,
		        rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
		    },
		    valor_impuesto: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
    	},
    	inline : true,

    });

    $('.btn_registrar').on('click', function() {
		if ($('#frmNuevo').form('is valid')) {
			$('#register_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmNuevo').form('validate form');
		}
  	});

	function sendForm() {

	    var data = $('#frmNuevo').serialize();
        $.requestApi('/empresa/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            if (resolve.message === "success") {
	                $.Helper.clearFields("#frmNuevo");
	            }
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
