$(function () {

	$.fn.form.settings.rules.habExiste = function(value) {
	  	return (verificaExiste('numero', value) > 0 ? false : true);
	};

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/habitacion/existeCampoEditar',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param, id_habitacion: $('#id_habitacion').val() },
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

    $('#frmEditar').form({
    	keyboardShortcuts: false,
    	fields: {
		    numero: {
		        rules: [
		        	{ type : 'habExiste', prompt : 'El numero de habitacion ya fue registrado'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'}
		        ]
		    },
		    precio: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un precio valido'},
		        ]
		    },
		    id_tipo_habitacion: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
    	},
    	inline : true,
    });

    $('.btn_guardar').on('click', function() {
		if ($('#frmEditar').form('is valid')) {
			$('#update_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmEditar').form('validate form');
		}
  	});

	function sendForm() {

	    var data = $('#frmEditar').serialize();

        $.requestApi('/habitacion/actualizar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
