$(function () {
	$.fn.form.settings.rules.habExiste = function(value) {
	  	return (verificaExiste('numero', value) > 0 ? false : true);
	};

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/habitacion/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
		    numero: {
		        rules: [
		        	{ type : 'habExiste', prompt : 'El numero de habitacion ya fue registrado'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'}
		        ]
		    },
		    precio: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un precio valido'},
		        ]
		    },
		    id_tipo_habitacion: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
    	},
    	inline : true,
    });

	$('.btn_registrar').on('click', function() {
		if ($('#frmNuevo').form('is valid')) {
			$('#register_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmNuevo').form('validate form');
		}
  	});

	function sendForm() {

	    var data = $('#frmNuevo').serialize();
        $.requestApi('/habitacion/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            if (resolve.message === "success") {
	                $.Helper.clearFields("#frmNuevo");
	            }
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
